package org.junitdoc.core.rewriter;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.junitdoc.JUnitDocPlugin;

public class Rewriter {

	public static void execute(final ICompilationUnit unit,
			final RewriteHandlerAdapter handler) {

		// WorkbenchJob job = new WorkbenchJob("test") {
		// @Override
		// public IStatus runInUIThread(IProgressMonitor monitor) {
		// monitor.beginTask("Rewriting...", IProgressMonitor.UNKNOWN);
		// execute(unit, handler, monitor);
		// monitor.done();
		// return Status.OK_STATUS;
		// }
		// };
		// job.setUser(true);
		//		job.schedule();

		 ProgressMonitorDialog dialog = new ProgressMonitorDialog(JUnitDocPlugin
				.getDefault().getWorkbench().getDisplay().getActiveShell());

		try {
			dialog.run(true, false, new IRunnableWithProgress() {
				public void run(IProgressMonitor monitor)
						throws InvocationTargetException, InterruptedException {
					monitor.beginTask("Rewriting...", IProgressMonitor.UNKNOWN);
					execute(unit, handler, monitor);
					monitor.done();
				}
			});
		} catch (InvocationTargetException e) {
		} catch (InterruptedException e) {
		}
	}

	public static void execute(ICompilationUnit unit,
			RewriteHandlerAdapter handler, IProgressMonitor monitor) {
		execute(unit, handler, true, monitor);
	}

	public static void execute(ICompilationUnit unit,
			RewriteHandlerAdapter handler, boolean forceCommit,
			IProgressMonitor monitor) {

		if (!handler.beforeRewrite()) {
			return;
		}

		if (monitor == null) {
			monitor = new NullProgressMonitor();
		}

		try {
			final ASTParser parser = ASTParser.newParser(AST.JLS3);
			parser.setSource(unit);
			ASTNode node = parser.createAST(new SubProgressMonitor(monitor, 1));

			String source = unit.getBuffer().getContents();
			IDocument document = new Document(source);

			ASTRewrite rewrite = ASTRewrite.create(node.getAST());

			handler.rewrite(node, rewrite);

			TextEdit edit = rewrite.rewriteAST(document, unit.getJavaProject()
					.getOptions(true));

			edit.apply(document);

			String newSource = document.get();

			// update of the compilation unit
			unit.getBuffer().setContents(newSource);

			if (forceCommit) {
				// commit changes
				unit.commitWorkingCopy(false, null);
			}

		} catch (Exception e) {
			JUnitDocPlugin.errorLog(e);

		} finally {
			handler.afterRewrite(unit);
		}
	}
}
