package org.junitdoc.core.rewriter;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;

public abstract class RewriteHandlerAdapter implements IRewriteHandler {

	public boolean beforeRewrite() {
		return true;
	}

	public abstract void rewrite(ASTNode node, ASTRewrite rewrite);

	public void afterRewrite(ICompilationUnit source) {
	}
}