package org.junitdoc.core.rewriter;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.junitdoc.ui.Const;

public class NewTestMethodHandler extends RewriteHandlerAdapter {

	private String decisionTableName;

	private String testMethodName;

	public NewTestMethodHandler(String decisionTableName, String testMethodName) {
		this.decisionTableName = decisionTableName;
		this.testMethodName = testMethodName;
	}

	@Override
	public void rewrite(ASTNode node, ASTRewrite rewrite) {

		TypeDeclaration type = ASTUtils.findFirstTypeDeclaration(node);

		AST ast = node.getAST();

		// declare test method.
		ListRewrite listRewrite = rewrite.getListRewrite(type,
				TypeDeclaration.BODY_DECLARATIONS_PROPERTY);

		MethodDeclaration newMethodDeclaration = ast.newMethodDeclaration();
		newMethodDeclaration.setName(ast.newSimpleName(testMethodName));

		// @decisionTableName
		MarkerAnnotation newDecisionTableMarkAnnotation = ast
				.newMarkerAnnotation();
		newDecisionTableMarkAnnotation.setTypeName(ast
				.newName(decisionTableName));
		newMethodDeclaration.modifiers().add(newDecisionTableMarkAnnotation);

		// @Test
		MarkerAnnotation newTestAnnotation = ast.newMarkerAnnotation();
		newTestAnnotation.setTypeName(ast.newName(Const.TEST_ANNOTATION));
		newMethodDeclaration.modifiers().add(newTestAnnotation);

		// add "public void".
		newMethodDeclaration.modifiers().add(
				ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
		newMethodDeclaration.setReturnType2(ast
				.newPrimitiveType(PrimitiveType.VOID));

		// add "throws Exception"
		newMethodDeclaration.thrownExceptions().add(
				ast.newSimpleName("Exception"));

		// add block {};
		MethodInvocation methodInvocation = ast.newMethodInvocation();
		methodInvocation.setName(ast.newSimpleName(Const.FAIL_METHOD)); 
		StringLiteral literal = ast.newStringLiteral();
		literal.setLiteralValue(Const.FAIL_METHOD_ARG);
		methodInvocation.arguments().add(literal);
		ExpressionStatement expressionStatement = ast.newExpressionStatement(methodInvocation);
		Block block = ast.newBlock();
		block.statements().add(expressionStatement);
		newMethodDeclaration.setBody(block);

		// write
		listRewrite.insertLast(newMethodDeclaration, null);

	}
}
