package org.junitdoc.core.decisiontable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.junitdoc.core.jdt.Annotation;

public class Type extends Annotation {

	private List<Type> children = new ArrayList<Type>();

	private List<Type> lastChildren = new ArrayList<Type>();

	private int checkedCount;

	private int depth;

	public Type(AnnotationTypeDeclaration annotation, int depth) {
		super(annotation);
		this.depth = depth;
	}

	public void addChild(Type type) {
		children.add(type);
	}

	public void addLastChild(Type type) {
		lastChildren.add(type);
	}

	public boolean hasChildren() {
		return children.size() > 0;
	}

	public List<Type> getChildren() {
		return children;
	}

	public List<Type> getLastChildren() {
		return lastChildren;
	}

	public int getDepth() {
		return depth;
	}

	public int getTotalDepth() {
		int rtn = 1;
		for (Type child : children) {
			rtn++;
			rtn += child.getTotalDepth();
		}
		return rtn;
	}

	public Collection<? extends Type> getTypeList() {
		List<Type> rtn = new ArrayList<Type>();
		for (Type child : children) {
			rtn.add(child);
			rtn.addAll(child.getTypeList());
		}
		return rtn;
	}

	public int getCheckedCount() {
		return checkedCount;
	}

	public void addCheckedCount() {
		checkedCount++;
	}

	public int getCheckedTotalCount() {
		int rtn = checkedCount;
		for (Type child : children) {
			rtn += child.getCheckedTotalCount();
		}
		return rtn;
	}

	public void clearCheckedCount() {
		checkedCount = 0;
	}
}
