package org.junitdoc.core.testcasetable;

import java.util.ArrayList;
import java.util.List;

public class Category {

	private String name;

	private List<Category> children = new ArrayList<Category>();

	public Category(String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public void addChild(Category category) {
		children.add(category);
	}

	public boolean hasChildren() {
		return children.size() > 0;
	}

	public List<Category> getChildren() {
		return children;
	}

	@Override
	public String toString() {
		return name;
	}
}
