/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.report;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;

import javax.servlet.ServletContext;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

import org.jtp.common.util.DateUtils;

/**
 * PDF帳票データを生成するクラスです。 
 *
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 204 $ $Date: 2007-06-06 01:03:34 +0900 $
 */
public class PdfReportGenerator implements ReportGenerator {
    
	/**
     * {@inheritDoc}
     */
	@SuppressWarnings("unchecked")
    public InputStream generate(ServletContext context, Collection collection) throws IOException {
        try {
            //PDF出力データを作成する
            InputStream stream = context.getResourceAsStream("/jasper/sample.jasper");
            JRBeanCollectionDataSource collectionDataSource = new JRBeanCollectionDataSource(collection);
            JasperPrint jasperPrint = JasperFillManager.fillReport(stream, null, collectionDataSource);
            
            //PDF一時ファイルを作成する
            byte[] buffer = JasperExportManager.exportReportToPdf(jasperPrint);
            createTemporaryFile(buffer);

            return new ByteArrayInputStream(buffer);
        }
        catch (JRException e) {
            throw new IOException(e.getMessage());
        }
    }

    /**
     * PDF一時ファイルを作成する
     * @param buffer 出力データ
     * @throws IOException I/O例外
     */
    private void createTemporaryFile(byte[] buffer) throws IOException {
        BufferedOutputStream writer = null;
        try {
            String name = "pdftmp_" + DateUtils.dateToString(new Date(), "yyyyMMddHHmmss");
            File tempDir = new File("");
            File tempFile = File.createTempFile(name, "", tempDir);
            tempFile.deleteOnExit();
            writer = new BufferedOutputStream(new FileOutputStream(tempFile));
            writer.write(buffer);
            writer.flush();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}
