/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action.sample;

import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.jtp.SampleException;
import org.jtp.common.util.PropertyUtilsWrapper;
import org.jtp.entity.test.TestTable;
import org.jtp.entity.test.TestTableDetail;
import org.jtp.logic.test.TestTableService;
import org.jtp.web.action.SampleActionSupport;
import org.jtp.web.bean.SampleUpdateBean;

import com.opensymphony.xwork2.inject.Inject;

/**
 * 更新画面のアクションクラスです。
 * 
 * @struts.action
 *  name="sample/UpdateForm"
 *  path="/sample/update"
 *  scope="request"
 *  validate="true"
 *  input="/sample/update.tiles"
 *  parameter="event"
 *  cancellable="true"
 * @struts.action-forward
 *  name="success"
 *  path="/sample/search.tiles"
 * @struts.action-forward
 *  name="cancel"
 *  path="/sample/search.tiles"
 *
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 204 $ $Date: 2007-06-06 01:03:34 +0900 $
 */
@SuppressWarnings("serial")
public class UpdateAction extends SampleActionSupport {

    /** テストテーブル情報サービス */
    private TestTableService testTableService;

    @Inject
    private SampleUpdateBean sampleUpdateBean;

    /**
     * テストテーブル情報サービスを設定します。
     * @param testTableService テストテーブル情報サービス
     */
	public void setTestTableService(TestTableService testTableService) {
		this.testTableService = testTableService;
	}
	
	public SampleUpdateBean getSampleUpdateBean() {
		return sampleUpdateBean;
	}

	public void setSampleUpdateBean(SampleUpdateBean sampleUpdateBean) {
		this.sampleUpdateBean = sampleUpdateBean;
	}

	/**
	 * 更新アクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	@SuppressWarnings("unchecked")
	public String success() throws Exception {
		
		Integer id = new Integer(getRequest().getParameter("id"));

		TestTable entity = null;

		List list = (List) getRequest().getSession().getAttribute("list");
		for (Iterator it = list.iterator(); it.hasNext();) {
			entity = (TestTable) it.next();
			if (entity.getId().intValue() == id.intValue()) {
				PropertyUtilsWrapper.copyProperties(getSampleUpdateBean(), entity);

		     	Set set = entity.getTestTableDetails();
		     	for (Iterator ite = set.iterator(); ite.hasNext();) {
		     		TestTableDetail detail = (TestTableDetail) ite.next();
		    		PropertyUtilsWrapper.copyProperties(getSampleUpdateBean(), detail);
		     	}
				break;
			}
		}
		
		testTableService.update(entity);
		
		getRequest().getSession(false).setAttribute("list", testTableService.find(new TestTable()));
		
		return SUCCESS;
	}
}
