/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action.mail;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.jtp.SampleException;
import org.jtp.common.util.PropertyUtilsWrapper;
import org.jtp.entity.mail.MailAddressTable;
import org.jtp.logic.mail.MailAddressTableService;
import org.jtp.web.action.SampleActionSupport;
import org.jtp.web.bean.MailAddressBean;

import com.opensymphony.xwork2.inject.Inject;

/**
 * アドレス帳設定画面アクションクラスです。
 * 
 * @struts.action
 *  name="mailAddressForm"
 *  path="/mail/address"
 *  scope="request"
 *  validate="true"
 *  input="/mail/address.tiles"
 *  parameter="event"
 * @struts.action-forward
 *  name="save"
 *  path="/mail/address.tiles"
 * @struts.action-forward
 *  name="update"
 *  path="/mail/address_update.tiles"
 * @struts.action-forward
 *  name="remove"
 *  path="/mail/address.tiles"
 * @struts.action-forward
 *  name="page"
 *  path="/mail/address.tiles"
 *
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 204 $ $Date: 2007-06-06 01:03:34 +0900 $
 */
@SuppressWarnings("serial")
public class AddressAction extends SampleActionSupport {
	
    /** このクラスで発生した実行状況をログに記録するためのオブジェクトです。 */
    private static final Log _log = LogFactory.getLog(AddressAction.class);

    /** メールアドレステーブル情報サービス */
    private MailAddressTableService mailAddressTableService;

    @Inject
    private MailAddressBean mailAddressBean;
    
    /**
     * メールアドレステーブル情報サービスを設定します。
     * @param mailTableService メールテーブル情報サービス
     */
	public void setMailAddressTableService(MailAddressTableService mailAddressTableService) {
		this.mailAddressTableService = mailAddressTableService;
	}

	public MailAddressBean getMailAddressBean() {
		return mailAddressBean;
	}

	public void setMailAddressBean(MailAddressBean mailAddressBean) {
		this.mailAddressBean = mailAddressBean;
	}

	/**
	 * 登録アクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	@SuppressWarnings("unchecked")
	public String save() throws Exception {
		
		MailAddressTable entity = new MailAddressTable();
		PropertyUtilsWrapper.copyProperties(getMailAddressBean(), entity);
		
		_log.info("save");
		
		mailAddressTableService.save(entity);
		
		_log.info("search");

		List result = mailAddressTableService.findAll();
		getRequest().getSession().setAttribute("addressList", result);

    	return SUCCESS;
    }

	/**
	 * 更新アクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	@SuppressWarnings("unchecked")
	public String update() throws Exception {
    	int index = Integer.parseInt(getRequest().getParameter("index"));
    	List list = (List) getRequest().getSession().getAttribute("addressList");
    	MailAddressTable mailAddressTable = (MailAddressTable) list.get(index);
     	getRequest().setAttribute("mailAddressTable", mailAddressTable);
    	return SUCCESS;
    }
    
    /**
     * 削除アクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	@SuppressWarnings("unchecked")
	public String remove() throws Exception {
    	int index = Integer.parseInt(getRequest().getParameter("index"));
    	List list = (List) getRequest().getSession().getAttribute("addressList");
    	MailAddressTable mailAddressTable = (MailAddressTable) list.get(index);
		
		_log.info("delete");
    	mailAddressTableService.delete(mailAddressTable);

		_log.info("search");
		List result = mailAddressTableService.findAll();
		getRequest().getSession().setAttribute("addressList", result);

		return SUCCESS;
    }

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected boolean isSkipTokenValid(ActionMapping mapping, HttpServletRequest request) {
		return true;
	}
}
