/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import org.jtp.SampleException;
import org.jtp.common.Encode;
import org.jtp.web.WebConstants;

/**
 * ダウンロード機能を実装したアクションクラスです。
 *
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 204 $ $Date: 2007-06-06 01:03:34 +0900 $
 */
public abstract class BaseDownloadAction extends SampleActionSupport implements Encode {

    /**
     * ファイルをダウンロードします。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	public String download() throws Exception {
    	getResponse().setContentType(getContentType());
    	getResponse().setHeader(WebConstants.HEADER_DISPOSITION, WebConstants.HEADER_VALUE  + encode(getFileName()));

		try {
	    	InputStream fis = getDownloadStream();
			BufferedOutputStream fos = new BufferedOutputStream(getResponse().getOutputStream());
	        int i;
			while((i = fis.read()) != -1){
	        	fos.write(i);
	        }
			fis.close();
			fos.flush();
			fos.close();
        }
        catch (IOException e) {
        	throw new SampleException(e);
        }
        
        return null;
    }
    
    /**
     * 日本語の文字化け防止のエンコーディング
     * @param str 対象文字列
     * @return String 変換後の文字列
     * @throws SampleException システム例外
     */
    protected String encode(String str) throws SampleException {
    	String result = null;
    	try {
    		if (str != null) {
    			result = URLEncoder.encode(str, UTF8);
    		}
        }
    	catch (UnsupportedEncodingException e) {
    		throw new SampleException(e);
    	}
    	return result;
    }

    /**
     * クライアントに送り返されるレスポンスのコンテントタイプを取得します。
     * @return クライアントに送り返されるレスポンスのコンテントタイプ
     */
    protected String getContentType() {
    	return WebConstants.CONTENT_TYPE_STREAM;
    }
    
    /**
     * ダウンロードファイル名を取得します。
     * @return ダウンロードファイル名
     */
    protected abstract String getFileName();
    
    /**
     * ダウンロードファイルの入力ストリームを取得します。
     * @return ダウンロードファイルの入力ストリーム
     * @throws IOException I/O例外
     */
    protected abstract InputStream getDownloadStream() throws IOException;
}
