/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web;

/* $Id: SessionManager.java 310 2008-08-12 03:17:56Z nagashiba $ */

import java.io.Serializable;
import java.util.HashMap;

/**
 * 常にセッションに保持する情報を管理するクラスです。
 *
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 310 $ $Date: 2008-08-12 12:17:56 +0900 $
 */
@SuppressWarnings("serial")
public final class SessionManager implements Serializable {

	/** セッション格納キー */
	public static final String ID = SessionManager.class.getName();
	
	/** セッション管理マップ */
	@SuppressWarnings("unchecked")
	private HashMap sessionMap = null;

	/**
	 * コンストラクタ 
	 */
	@SuppressWarnings("unchecked")
	public SessionManager() {
		super();
		this.sessionMap = new HashMap();
	}

	/**
	 * セッションデータ設定
	 * @param key キー
	 * @param value オブジェクト
	 */
	@SuppressWarnings("unchecked")
	public void setAttribute(String key, Object value) {
		this.sessionMap.put(key, value);
	}

	/**
	 * セッションデータ取得
	 * @param key キー
	 * @return オブジェクト
	 */
	public Object getAttribute(String key) {
		return this.sessionMap.get(key);
	}
	
	/**
	 * セッションデータ削除
	 * @param key キー
	 */
	public void removeAttribute(String key) {
		this.sessionMap.remove(key);
	}
	
	/**
	 * クリア
	 */
	public void clear() {
		sessionMap.clear();
	}
}
