/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web;


import javax.servlet.ServletException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;

/**
 * アプリケーション起動やアプリケーション終了イベントについて通知する必要がある、
 * 特定モジュールのリソースまたはサービスのための設定用ラッパーです。
 *
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 204 $ $Date: 2007-06-06 01:03:34 +0900 $
 */
public class InitPlugin implements PlugIn {
	
    /** このクラスで発生した実行状況をログに記録するためのオブジェクトです。 */
    private static final Log _log = LogFactory.getLog(InitPlugin.class);
    
	/**
	 * モジュールが起動する通知を受け取ります。
	 * @param	actionServlet このWebアプリケーションの全てのモジュールを処理するActionServlet
	 * @param  moduleConfig このプラグインに関連付けられたモジュールのModuleConfig
	 * @throws ServletException サーブレット例外
	 */
	public void init(ActionServlet actionServlet, ModuleConfig moduleConfig) throws ServletException {
		try {
			_log.info("init start");

			//コンテキストにオブジェクトを設定する場合は、ここに記述する
			
			_log.info("init end");

			return;
		} catch (Exception e) {
			_log.error(e.getMessage());
			throw new ServletException(e);
		}
	}

	/**
	 * モジュールが終了する通知を受け取ります。
	 */
	public void destroy() {
		try {
			_log.info("destroy start");

			_log.info("destroy end");

		} catch (Exception e) {
			_log.error(e.getMessage());
		}
	}
}