/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.interceptor;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.jtp.web.action.SessionTimeoutManager;
import org.jtp.web.exception.TimeoutException;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;

/* $Id: SessionManagementInterceptor.java 299 2008-06-16 16:23:00Z nagashiba $ */

/**
 * セッション管理を行うインターセプタークラスです。
 *
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 299 $ $Date: 2008-06-17 01:23:00 +0900 $
 */
@SuppressWarnings("serial")
public class SessionManagementInterceptor extends AbstractInterceptor {
	
    /** このクラスで発生した実行状況をログに記録するためのオブジェクトです。 */
    private Log _log = null;

	/**
	 * 実行メソッドをインターセプトします。
	 * @param invocation 
	 */
	@Override
	public String intercept(ActionInvocation invocation) throws Exception {
		_log = LogFactory.getLog(invocation.getAction().getClass());
		
    	_log.info("#execute start");
		
		SessionTimeoutManager timeoutManager = (SessionTimeoutManager) invocation.getAction();
		
		//セッションタイムアウトのチェック
		if (!isTimeOut(timeoutManager)) {
	    	_log.info("#execute TimeOut Error");
			throw new TimeoutException("タイムアウトです。");
		}

		String result = invocation.invoke();
		
    	_log.info("#execute end");
    	
    	return result;
	}

	/**
	 * タイムアウトを確認します
	 * @param mapping  このインスタンスを選択するために使用したActionMapping
	 * @param request  処理しているHTTPリクエスト
	 * @return true[続行]、false[タイムアウト]
	 */
	private boolean isTimeOut(SessionTimeoutManager timeout) {
		boolean result = true;
		ActionMapping mapping = ServletActionContext.getActionMapping();
		HttpServletRequest request = ServletActionContext.getRequest();
		
		if (timeout.isSkipTimeOut(mapping, request)) return true;
		
		if (timeout.getSessionManager() == null) {
			result = false;
		}

		return result;
	}
}
