/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.interceptor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.components.ActionError;
import org.apache.struts2.components.ActionMessage;
import org.jtp.web.exception.TimeoutException;
import org.jtp.web.exception.TokenValidException;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.ExceptionHolder;
import com.opensymphony.xwork2.interceptor.ExceptionMappingInterceptor;

/* $Id: SampleExceptionMappingInterceptor.java 299 2008-06-16 16:23:00Z nagashiba $ */

/**
 * 例外処理をハンドリングするクラスです。
 *
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 299 $ $Date: 2008-06-17 01:23:00 +0900 $
 */
@SuppressWarnings("serial")
public class SampleExceptionMappingInterceptor extends ExceptionMappingInterceptor {
	
    /** このクラスで発生した実行状況をログに記録するためのオブジェクトです。 */
    private static final Log _log = LogFactory.getLog(SampleExceptionMappingInterceptor.class);

    /**
     * 
     * @param invocation 
     * @param exceptionHolder 
     */
    @SuppressWarnings("unused")
	@Override
	protected void publishException(ActionInvocation invocation, ExceptionHolder exceptionHolder) {
		Exception ex = exceptionHolder.getException();

		String property = null;
		ActionMessage message = null;
		ActionError e = null;
		// タイムアウトの場合
		if (ex instanceof TimeoutException) {
			property = "timeout";
//			message = new ActionMessage("msg.timeout");
		}
		// トークンエラーの場合
		else if (ex instanceof TokenValidException) {
			property = "token";
//			message = new ActionMessage("msg.token");
//			_log.info("request: "
//					+ invocation.getInvocationContext().get.getParameter(Constants.TOKEN_KEY));
//			_log.info("session: "
//					+ getRequest().getSession().getAttribute(
//							Globals.TRANSACTION_TOKEN_KEY));
		}
		// 以外の場合
		else {
			property = "error";
//			if (ex.getMessage() != null) {
//				message = new ActionMessage("errors.msg", ex.getMessage());
//			} else {
//				message = new ActionMessage("errors.msg.error", mapping
//						.getType(), ex.toString());
//			}
		}

		_log.error(ex.getMessage(), ex);

		super.publishException(invocation, exceptionHolder);
	}
}
