/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.bean;

/* $Id: SelectBean.java 299 2008-06-16 16:23:00Z nagashiba $ */

import java.io.Serializable;

import org.jtp.entity.Selectable;

/**
 * UIから選択可能なデータを格納するクラスです。
 * 
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 299 $ $Date: 2008-06-17 01:23:00 +0900 $
 */
@SuppressWarnings("serial")
public class SelectBean implements Serializable, Selectable {

	private String label;
	
	private String value;

	public SelectBean() {
		this(null, null);
	}
	
	public SelectBean(String label, String value) {
		setLabel(label);
		setValue(value);
	}
	
	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}
}
