/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action.sample;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.jtp.SampleException;
import org.jtp.common.util.DateUtils;
import org.jtp.common.util.PropertyUtilsWrapper;
import org.jtp.entity.test.TestTable;
import org.jtp.entity.test.TestTableDetail;
import org.jtp.logic.test.TestTableService;
import org.jtp.web.WebConstants;
import org.jtp.web.action.BaseDownloadAction;
import org.jtp.web.bean.PdfBean;
import org.jtp.web.bean.SampleInputBean;
import org.jtp.web.report.CsvReportGenerator;
import org.jtp.web.report.PdfReportGenerator;
import org.jtp.web.report.ReportGenerator;

import com.opensymphony.xwork2.inject.Inject;

/**
 * 検索画面アクションクラスです。
 * 
 * @struts.action
 *  name="sample/InputForm"
 *  path="/sample/search"
 *  scope="request"
 *  validate="true"
 *  input="/sample/search.tiles"
 *  parameter="event"
 *  cancellable="true"
 * @struts.action-forward
 *  name="search"
 *  path="/sample/search.tiles"
 * @struts.action-forward
 *  name="save"
 *  path="/sample/search.tiles"
 * @struts.action-forward
 *  name="update"
 *  path="/sample/update.tiles"
 * @struts.action-forward
 *  name="remove"
 *  path="/sample/remove.tiles"
 * @struts.action-forward
 *  name="download"
 *  path="/sample/search.tiles"
 * @struts.action-forward
 *  name="pdf"
 *  path="/sample/search.tiles"
 * @struts.action-forward
 *  name="page"
 *  path="/sample/search.tiles"
 * @struts.action-forward
 *  name="cancel"
 *  path="/jsp/common/menu.jsp"
 *
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 204 $ $Date: 2007-06-06 01:03:34 +0900 $
 */
@SuppressWarnings("serial")
public class SearchAction extends BaseDownloadAction {
	
    /** このクラスで発生した実行状況をログに記録するためのオブジェクトです。 */
    private static final Log _log = LogFactory.getLog(SearchAction.class);

    /** テストテーブル情報サービス */
    private TestTableService testTableService;

    @Inject
    private SampleInputBean sampleInputBean;
    
    /**
     * テストテーブル情報サービスを設定します。
     * @param testTableService テストテーブル情報サービス
     */
	public void setTestTableService(TestTableService testTableService) {
		this.testTableService = testTableService;
	}
	
	public SampleInputBean getSampleInputBean() {
		return sampleInputBean;
	}

	public void setSampleInputBean(SampleInputBean sampleInputBean) {
		this.sampleInputBean = sampleInputBean;
	}
	
    /**
     * 検索アクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	@SuppressWarnings("unchecked")
	public String search() throws Exception {
		
		TestTable condition = new TestTable();
		PropertyUtilsWrapper.copyProperties(getSampleInputBean(), condition);
		
		List result = testTableService.find(condition);
		
		getRequest().getSession().setAttribute("list", result);
		getRequest().setAttribute("testTable", condition);

    	return SUCCESS;
    }

	/**
	 * 登録アクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	public String save() throws Exception {
		
		TestTable condition = new TestTable();
		PropertyUtilsWrapper.copyProperties(getSampleInputBean(), condition);
		
		_log.info("save");
		
		testTableService.save(condition);
		
		getRequest().getSession().setAttribute("list", testTableService.find(new TestTable()));

    	return SUCCESS;
    }
    
    /**
     * 更新アクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	@SuppressWarnings("unchecked")
	public String update() throws Exception {
    	int index = Integer.parseInt(getRequest().getParameter("index"));
    	List list = (List) getRequest().getSession().getAttribute("list");
    	TestTable testTable = (TestTable) list.get(index);
     	getRequest().setAttribute("testTable", testTable);
     	Set detail = testTable.getTestTableDetails();
     	for (Iterator it = detail.iterator(); it.hasNext();) {
        	getRequest().setAttribute("testTableDetail", it.next());
     	}
    	return SUCCESS;
    }
    
    /**
     * 削除アクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	@SuppressWarnings("unchecked")
	public String remove() throws Exception {
    	int index = Integer.parseInt(getRequest().getParameter("index"));
    	List list = (List) getRequest().getSession().getAttribute("list");
    	getRequest().setAttribute("testTable", list.get(index));
    	return SUCCESS;
    }
    
    /**
     * {@inheritDoc}
     */
	@Override
	public String cancel() throws Exception {
    	getRequest().getSession().removeAttribute("list");
    	return super.cancel();
    }
	
    /**
     * PDFファイルをダウンロードします。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	public String pdf() throws Exception {
    	return super.download();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String page() throws Exception {
		TestTable condition = (TestTable) getRequest().getSession().getAttribute("testTable");
		PropertyUtilsWrapper.copyProperties(getSampleInputBean(), condition);
		return super.page();
	}

    /**
     * {@inheritDoc}
     */
	@Override
    protected String getContentType() {
		String result = super.getContentType();
		String event = getRequest().getParameter("");
		if ("pdf".equals(event)) {
			result = WebConstants.CONTENT_TYPE_PDF;
		}
		return result;
    }
    
    /**
     * {@inheritDoc}
     */
	@Override
    protected String getFileName() {
		String result = null;
		String event = getRequest().getParameter("");
    	String date = DateUtils.dateToString(new Date(), "yyyyMMddHHmmss");
		if ("download".equals(event)) {
			result = "ほげ-" + date + ".txt";
		}
		else if ("pdf".equals(event)) {
			result = "ほげ-" + date + ".pdf";
		}
		return result;
	}

    /**
     * {@inheritDoc}
     */
	@Override
	@SuppressWarnings("unchecked")
    protected InputStream getDownloadStream() throws IOException {

    	ReportGenerator genetator;
    	List list = null;
    	
    	if (getResponse().getContentType().equals(WebConstants.CONTENT_TYPE_PDF)) {
    		genetator = new PdfReportGenerator();
    		List arg = (List) getRequest().getSession().getAttribute("list");
    		list = new ArrayList();
    		for (Iterator it = arg.iterator(); it.hasNext();) {
    			TestTable entity = (TestTable) it.next();
    			PdfBean pdf = new PdfBean();
    			PropertyUtilsWrapper.copyProperties(entity, pdf);
   		     	Set set = entity.getTestTableDetails();
   		     	for (Iterator ite = set.iterator(); ite.hasNext();) {
   		     		TestTableDetail detail = (TestTableDetail) ite.next();
   		    		PropertyUtilsWrapper.copyProperties(detail, pdf);
   		     	}
   		     	list.add(pdf);
    		}
    	}
    	else {
    		genetator = new CsvReportGenerator();
    		list = (List) getRequest().getSession().getAttribute("list");
    	}
    	
		return genetator.generate(getServletContext(), list);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	protected boolean isSkipSaveToken(ActionMapping mapping, HttpServletRequest request) {
		String event = getRequest().getParameter("");
		return ("download".equals(event) || "pdf".equals(event));
	}
}
