/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action.mail;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.jtp.SampleException;
import org.jtp.common.util.PropertyUtilsWrapper;
import org.jtp.entity.mail.MailAccountTable;
import org.jtp.logic.mail.MailAccountTableService;
import org.jtp.web.action.SampleActionSupport;
import org.jtp.web.bean.MailAddressBean;

import com.opensymphony.xwork2.inject.Inject;

/**
 * アカウント設定画面アクションクラスです。
 * 
 * @struts.action
 *  name="mailAddressForm"
 *  path="/mail/account"
 *  scope="request"
 *  validate="true"
 *  input="/mail/account.tiles"
 *  parameter="event"
 * @struts.action-forward
 *  name="save"
 *  path="/mail/account.tiles"
 * @struts.action-forward
 *  name="update"
 *  path="/mail/account_update.tiles"
 * @struts.action-forward
 *  name="remove"
 *  path="/mail/account.tiles"
 * @struts.action-forward
 *  name="page"
 *  path="/mail/account.tiles"
 *
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 204 $ $Date: 2007-06-06 01:03:34 +0900 $
 */
@SuppressWarnings("serial")
public class AccountAction extends SampleActionSupport {
	
    /** このクラスで発生した実行状況をログに記録するためのオブジェクトです。 */
    private static final Log _log = LogFactory.getLog(AccountAction.class);

    /** アカウントテーブル情報サービス */
    private MailAccountTableService mailAccountTableService;

    @Inject
    private MailAddressBean mailAddressBean;

    /**
     * アカウントテーブル情報サービスを設定します。
     * @param mailAccountTableService アカウントテーブル情報サービス
     */
	public void setMailAccountTableService(MailAccountTableService mailAccountTableService) {
		this.mailAccountTableService = mailAccountTableService;
	}

	public MailAddressBean getMailAddressBean() {
		return mailAddressBean;
	}

	public void setMailAddressBean(MailAddressBean mailAddressBean) {
		this.mailAddressBean = mailAddressBean;
	}

	/**
	 * 登録アクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	@SuppressWarnings("unchecked")
	public String save() throws Exception {
		
		MailAccountTable entity = new MailAccountTable();
		PropertyUtilsWrapper.copyProperties(getMailAddressBean(), entity);
		
		_log.info("save");
		
		mailAccountTableService.save(entity);
		
		_log.info("search");

		List result = mailAccountTableService.findAll();
		getRequest().getSession().setAttribute("accountList", result);

    	return SUCCESS;
    }

	/**
	 * 更新アクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	@SuppressWarnings("unchecked")
	public String update() throws Exception {
    	int index = Integer.parseInt(getRequest().getParameter("index"));
    	List list = (List) getRequest().getSession().getAttribute("accountList");
    	MailAccountTable mailAccountTable = (MailAccountTable) list.get(index);
     	getRequest().setAttribute("mailAccountTable", mailAccountTable);
    	return SUCCESS;
    }
    
    /**
     * 削除アクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	@SuppressWarnings("unchecked")
	public String remove() throws Exception {
    	int index = Integer.parseInt(getRequest().getParameter("index"));
    	List list = (List) getRequest().getSession().getAttribute("accountList");
    	MailAccountTable entity = (MailAccountTable) list.get(index);
		
		_log.info("delete");
    	mailAccountTableService.delete(entity);

		_log.info("search");
		List result = mailAccountTableService.findAll();
		getRequest().getSession().setAttribute("accountList", result);

		return SUCCESS;
    }

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected boolean isSkipTokenValid(ActionMapping mapping, HttpServletRequest request) {
		return true;
	}
}
