/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action.common;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.jtp.SampleException;
import org.jtp.web.SessionManager;
import org.jtp.web.action.SampleActionSupport;

/**
 * メニュー画面アクションクラスです。
 * 
 * @struts.action
 *  name="common/MenuForm"
 *  path="/common/menu"
 *  scope="request"
 *  validate="false"
 *  input="/common/menu.jsp"
 *  parameter="event"
 * @struts.action-forward
 *  name="success"
 *  path="/sample/search.tiles"
 * @struts.action-forward
 *  name="mail"
 *  path="/mail/top.tiles"
 *
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 204 $ $Date: 2007-06-06 01:03:34 +0900 $
 */
@SuppressWarnings("serial")
public class MenuAction extends SampleActionSupport {
	
	/**
	 * メニューアクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	public String success() throws Exception {
		getRequest().getSession().setAttribute(SessionManager.ID, new SessionManager());
    	return SUCCESS;
    }
	
	/**
	 * メニューアクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	public String mail() throws Exception {
		getRequest().getSession().setAttribute(SessionManager.ID, new SessionManager());
    	return SUCCESS;
    }

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isSkipTimeOut(ActionMapping mapping, HttpServletRequest request) {
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected boolean isSkipTokenValid(ActionMapping mapping, HttpServletRequest request) {
		return true;
	}
}
