/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action;

/* $Id: SampleActionSupport.java 314 2008-08-12 03:18:54Z nagashiba $ */

import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.ObjectUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.interceptor.SessionAware;
import org.jtp.SampleException;
import org.jtp.web.SessionManager;
import org.jtp.web.WebConstants;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;

/**
 * 基本アクションクラスです。
 *
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 314 $ $Date: 2008-08-12 12:18:54 +0900 $
 */
@SuppressWarnings("serial")
public class SampleActionSupport extends ActionSupport implements SessionAware, SessionTimeoutManager {

	/** 頁番号であることを意味します */
	private static final String PAGE_NUMBER = "pageNum";

	@SuppressWarnings("unchecked")
	private Map sessionMap;

	@SuppressWarnings("unchecked")
	public void setSession(Map sessionMap) {
		this.sessionMap = sessionMap;
	}
	
	/**
	 * セッションからセッション管理オブジェクトを取得します。
	 * @param session  処理しているHTTPセッション
	 * @return セッション管理オブジェクト
	 */
    public final SessionManager getSessionManager() {
		return (SessionManager) ActionContext.getContext().getSession().get(SessionManager.ID);
	}
	
	/**
	 * タイムアウト確認を行なわないかを確認します。
	 * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param request  処理しているHTTPリクエスト
	 * @return true[行わない]、false[行う]
	 */
	public boolean isSkipTimeOut(ActionMapping mapping, HttpServletRequest request) {
		return false;
	}

	/**
	 * 改頁アクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	public String page() throws Exception {
		//改頁後の頁番号をリクエストに設定する
		getRequest().setAttribute(PAGE_NUMBER, ObjectUtils.toString(getRequest().getParameter("pageNum"), "-1"));
    	return getRequest().getParameter(getRequest().getParameter("event"));
	}

    /**
     * 戻るアクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	public String cancel() throws Exception {
    	return WebConstants.FORWARD_CANCEL;
    }

	/**
     * アクションマッピングを取得します。
     * @return アクションマッピング
	 */
	protected final ActionMapping getActionMapping() {
    	return ServletActionContext.getActionMapping();
	}

	/**
     * HTTPリクエストを取得します。
     * @return HTTPリクエスト
	 */
	protected final HttpServletRequest getRequest() {
		return ServletActionContext.getRequest();
	}

	/**
     * HTTPレスポンスを取得します。
     * @return HTTPレスポンス
	 */
	protected final HttpServletResponse getResponse() {
		return ServletActionContext.getResponse();
	}

    /**
     * サーブレットコンテキストを取得します。
     * @return サーブレットコンテキスト
     */
    protected final ServletContext getServletContext() {
    	return ServletActionContext.getServletContext();
    }
	
	/**
	 * トークン保存を行なわないかを確認します
	 * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param request  処理しているHTTPリクエスト
	 * @return true[行わない]、false[行う]
	 */
	protected boolean isSkipSaveToken(ActionMapping mapping, HttpServletRequest request) {
		return false;
	}
	
	/**
	 * トークン確認を行なわないかを確認します
	 * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param request  処理しているHTTPリクエスト
	 * @return true[行わない]、false[行う]
	 */
	protected boolean isSkipTokenValid(ActionMapping mapping, HttpServletRequest request) {
		return false;
	}

	@SuppressWarnings("unchecked")
	protected Map getSessionMap() {
		return sessionMap;
	}
}
