/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.logic.mail;

import java.util.List;

import org.jtp.SampleException;
import org.jtp.dao.mail.MailAccountTableDao;
import org.jtp.entity.mail.MailAccountTable;


/** 
 * アカウントテーブル情報のサービスクラスです。
 * 
 * @spring.bean id="mailAccountTableService" 
 * @spring.property name="mailAccountTableDao" ref="mailAccountTableDao"
 * 
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 */
public class MailAccountTableServiceImpl implements MailAccountTableService {

	/** アカウントテーブル情報DAO */
	private MailAccountTableDao mailAccountTableDao;
	
    /**
     * Setter Injection
     */
	public void setMailAccountTableDao(MailAccountTableDao mailAccountTableDao) {
		this.mailAccountTableDao = mailAccountTableDao;
	}
	
	/**
	 * 検索します。
	 * @return エンティティのリスト
	 * @throws SampleException システム一般例外
	 */
	@SuppressWarnings("unchecked")
    public List findAll() throws SampleException {
    	return mailAccountTableDao.findAll();
    }
    
	/**
	 * 登録します。
	 * @param mailAccountTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void save(MailAccountTable mailAccountTable) throws SampleException {
    	mailAccountTableDao.save(mailAccountTable);
    }

	/**
	 * 更新します。
	 * @param mailAccountTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void update(MailAccountTable mailAccountTable) throws SampleException {
    	mailAccountTableDao.update(mailAccountTable);
    }
    
	/**
	 * 削除します。
	 * @param mailAccountTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void delete(MailAccountTable mailAccountTable) throws SampleException {
    	mailAccountTableDao.delete(mailAccountTable);
    }
}
