/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.logic.interceptor;

import java.io.Serializable;
import java.util.Date;

import org.hibernate.CallbackException;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;
import org.jtp.entity.Auditable;


/**
 * 登録、更新インターセプタクラスです。
 * 
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 */
@SuppressWarnings("serial")
public class AudiEntityInterceptor extends EmptyInterceptor { 

    /**
     * エンティティの永続化の際に作成ユーザーと日時を記録します。
     * @param entity
     * @param id
     * @param state
     * @param propertyNames
     * @param types
     * @return
     * @throws CallbackException
     */
    public boolean onSave(Object entity, Serializable id, Object[] state,
            String[] propertyNames, Type[] types) throws CallbackException {
    	if (!(entity instanceof Auditable)) {
            return false;
        }
        int modified = 0;
        for (int i = 0; i < propertyNames.length; i++) {
            if (modified >= 2) {
                break;
            } else if ("createDate".equals(propertyNames[i])) {
                state[i] = new Date();
                modified++;
            } else if ("updateDate".equals(propertyNames[i])) {
            	state[i] = new Date();
                modified++;
            }
        }
        return (modified > 0);
    }

    /**
     * エンティティの永続化の際に更新ユーザーと日時を記録します。
     * @param entity
     * @param id
     * @param currentState
     * @param previousState
     * @param propertyNames
     * @param types
     * @return
     * @throws CallbackException
     */
    public boolean onFlushDirty(Object entity, Serializable id,
            Object[] currentState, Object[] previousState,
            String[] propertyNames, Type[] types) throws CallbackException {
    	if (!(entity instanceof Auditable)) {
            return false;
        }
        int modified = 0;
        for (int i = 0; i < propertyNames.length; i++) {
            if (modified >= 1) {
                break;
            } else if ("updateDate".equals(propertyNames[i])) {
                currentState[i] = new Date();
                modified++;
            }
        }
        return (modified > 0);
    }
}
