/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.dao.test;

import org.jtp.SampleException;
import org.jtp.dao.BaseDao;
import org.jtp.entity.test.TestTableDetail;

/**
 * データアクセスクラスです。
 * 
 * @spring.bean id="testTableDetailDao" 
 * @spring.property name="sessionFactory" ref="sessionFactory" 
 * 
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 */
public class TestTableDetailDaoImpl extends BaseDao implements TestTableDetailDao {
	
	/**
	 * 登録します。
	 * @param testTableDetail エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void save(TestTableDetail testTableDetail) throws SampleException {
    	getHibernateTemplate().save(testTableDetail);
    	getHibernateTemplate().flush();
    }

	/**
	 * 更新します。
	 * @param testTableDetail エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void update(TestTableDetail testTableDetail) throws SampleException {
    	getHibernateTemplate().update(testTableDetail);
    	getHibernateTemplate().flush();
    }
    
	/**
	 * 削除します。
	 * @param testTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void delete(TestTableDetail testTableDetail) throws SampleException {
    	getHibernateTemplate().delete(testTableDetail);
    	getHibernateTemplate().flush();
    }
}
