#include "x11-core.h"

JtkSurface* jtkCreateWindowSurface(JtkWindow *jw, int width, int height)
{
	JtkSurface *surface = NULL;
	int bpp;
	
	surface = j_malloc(sizeof(JtkSurface));
	if(surface == NULL)
		return NULL;
	j_zero(surface, sizeof(JtkSurface));
	
	/* create SHM-Pixmap */
	bpp = XShmPixmapFormat(display);
	surface->shm_info.shmid = shmget(IPC_PRIVATE,
							width * height * bpp,
							IPC_CREAT | 0777);
	surface->shm_info.shmaddr = surface->shm_data 
			= shmat(surface->shm_info.shmid, 0, 0);
	surface->shm_info.readOnly = False;
	XShmAttach(display, &surface->shm_info);
	surface->shm_pixmap_id = XShmCreatePixmap(display, jw->window_id,
						surface->shm_data,
						&surface->shm_info, width, height, bpp * 8);
	
	return surface;
}

JtkSurface* jtkCreateSurface(JtkWidget *widget, int width, int height)
{
	JtkWindow *jw;

	jw = jtkGetDrawingArea(widget);
	return jtkCreateWindowSurface(jw, width, height);
}

void jtkDestroySurface(JtkSurface *surface)
{
	/* destroy SHM-Pixmap */
	XShmDetach(display, &surface->shm_info);
	XFreePixmap(display, surface->shm_pixmap_id);
	shmdt(surface->shm_info.shmaddr);
	shmctl(surface->shm_info.shmid, IPC_RMID, 0);
	j_free(surface);
}

void* jtkLockSurface(JtkSurface *surface)
{
	XSync(display, False);
	return surface->shm_data;
}

void jtkUnlockSurface(JtkSurface *surface)
{
	XSync(display, False);
}
