#include "x11-core.h"

static JtkImage* load_rgba(char *name)
{
	JtkImage *image;
	JtkColor pixel;
	FILE *fp;
	unsigned char s[4] = {0};
	int w, h;
	int x, y;
	
	if((fp = fopen(name, "r")) == NULL)
		return NULL;
	
	if(fread(s, 4, 1, fp) < 1){
		fclose(fp);
		return NULL;
	}
	
	if((s[0] != 0xfe) || (s[1] != 0xd3) ||
		(s[2] == 0) || (s[3] == 0)){
		fclose(fp);
		return NULL;
	}
	
	w = s[2];
	h = s[3];
	if((image = jtkCreateImage(w, h)) == NULL){
		fclose(fp);
		return NULL;
	}
	
	for(y=0; y<h; y++){
		for(x=0; x<w; x++){
			if(fread(s, 4, 1, fp) < 1){
				jtkDestroyImage(image);
				fclose(fp);
				return NULL;
			}
			pixel = jtkRGBA(s[0], s[1], s[2], s[3]);
			jtkPutPixel(image, pixel, x, y);
		}
	}
	
	fclose(fp);
	return image;
}

static void save_rgba(JtkImage *image, char *name)
{
	JtkColor pixel;
	FILE *fp;
	unsigned char s[4] = {0};
	int w, h;
	int x, y;
	
	if((fp = fopen(name, "w")) == NULL)
		return;
	
	s[0] = 0xfe;
	s[1] = 0xd3;
	s[2] = image->width & 0xff;
	s[3] = image->height & 0xff;
	if(fwrite(s, 4, 1, fp) < 1){
		fclose(fp);
		return;
	}
	
	w = s[2];
	h = s[3];
	for(y=0; y<h; y++){
		for(x=0; x<w; x++){
			pixel = jtkGetPixel(image, x, y);
			s[0] = jtkGetRValue(pixel);
			s[1] = jtkGetGValue(pixel);
			s[2] = jtkGetBValue(pixel);
			s[3] = jtkGetAValue(pixel);
			
			if(fwrite(s, 4, 1, fp) < 1){
				fclose(fp);
				return;
			}
		}
	}
	
	fclose(fp);
}

JtkImage* jtkLoadImageFile(char *name)
{
	JtkImage *image = NULL;

	image = load_rgba(name);
	return image;
}

void jtkSaveImageFile(JtkImage *image, char *name)
{
	save_rgba(image, name);
}
