#include "x11-core.h"

static char *def_font_set = "-*-gothic-medium-r-normal--12-*";

/* graphics */
JtkGC* jtkCreateWindowGC(JtkWindow *jw)
{
	JtkGC *gc = NULL;
	char **miss, *def;
	int n_miss;
	
	gc = j_malloc(sizeof(JtkGC));
	if(gc == NULL)
		return NULL;
	j_zero(gc, sizeof(JtkGC));

	gc->drawable = jw->window_id;
	gc->gc = XCreateGC(display, jw->window_id, 0, 0);
	gc->fs = XCreateFontSet(display, def_font_set, &miss, &n_miss, &def);
	
	return gc;
}

JtkGC* jtkCreateGC(JtkWidget *widget)
{
	JtkWindow *jw;

	jw = jtkGetDrawingArea(widget);
	return jtkCreateWindowGC(jw);
}

JtkGC* jtkCreatePixmapGC(JtkPixmap *pixmap)
{
	JtkGC *gc = NULL;
	char **miss, *def;
	int n_miss;
	
	gc = j_malloc(sizeof(JtkGC));
	if(gc == NULL)
		return NULL;
	j_zero(gc, sizeof(JtkGC));
	
	gc->drawable = pixmap->pixmap_id;
	gc->gc = XCreateGC(display, pixmap->pixmap_id, 0, 0);
	gc->fs = XCreateFontSet(display, def_font_set, &miss, &n_miss, &def);
	
	return gc;
}

JtkGC* jtkCreateSurfaceGC(JtkSurface *surface)
{
	JtkGC *gc = NULL;
	char **miss, *def;
	int n_miss;
	
	gc = j_malloc(sizeof(JtkGC));
	if(gc == NULL)
		return NULL;
	j_zero(gc, sizeof(JtkGC));

	gc->drawable = surface->shm_pixmap_id;
	gc->gc = XCreateGC(display, surface->shm_pixmap_id, 0, 0);
	gc->fs = XCreateFontSet(display, def_font_set, &miss, &n_miss, &def);
	
	return gc;
}

void jtkDestroyGC(JtkGC *gc)
{
	XFreeFontSet(display, gc->fs);
	XFreeGC(display, gc->gc);
	j_free(gc);
}

void jtkBitBlt(JtkGC *src, JtkGC *dest, int src_x, int src_y,
					int width, int height, int dest_x, int dest_y)
{
	XCopyArea(display, src->drawable, dest->drawable, src->gc,
				src_x, src_y, width, height,
				dest_x, dest_y);
	XFlush(display);
}

void jtkSetColor(JtkGC *gc, JtkColor color)
{
	XSetForeground(display, gc->gc, x11_make_rgb(color));
	XFlush(display);
}

void jtkSetBackColor(JtkGC *gc, JtkColor color)
{
	XSetBackground(display, gc->gc, x11_make_rgb(color));
	XFlush(display);
}

void jtkSetLineAttributes(JtkGC *gc, unsigned int size,
								JtkLineStyle line_style,
								JtkCapStyle cap_style,
								JtkJoinStyle join_style)
{
	int ls = LineSolid;
	int cs = CapButt;
	int js = JoinMiter;
	
	switch(line_style){
	case JTK_LINESTYLE_SOLID:
		ls = LineSolid;
		break;
	case JTK_LINESTYLE_ONOFFDASH:
		ls = LineOnOffDash;
		break;
	case JTK_LINESTYLE_DOUBLEDASH:
		ls = LineDoubleDash;
		break;
	}
	
	switch(cap_style){
	case JTK_CAPSTYLE_BUTT:
		cs = CapButt;
		break;
	case JTK_CAPSTYLE_ROUND:
		cs = CapRound;
		break;
	case JTK_CAPSTYLE_PROJECTING:
		cs = CapProjecting;
		break;
	}
	
	switch(join_style){
	case JTK_JOINSTYLE_MITER:
		js = JoinMiter;
		break;
	case JTK_JOINSTYLE_ROUND:
		js = JoinRound;
		break;
	case JTK_JOINSTYLE_BEVEL:
		js = JoinBevel;
		break;
	}
	
	XSetLineAttributes(display, gc->gc, size, ls, cs, js);
}

void jtkSetDashes(JtkGC *gc, int offset, char dash_list[], int n)
{
	XSetDashes(display, gc->gc, offset, dash_list, n);
}

void jtkDrawLine(JtkGC *gc, int x1, int y1, int x2, int y2)
{
	XDrawLine(display, gc->drawable, gc->gc, x1, y1, x2, y2);
	XFlush(display);
}

void jtkDrawPoint(JtkGC *gc, int x, int y)
{
	XDrawPoint(display, gc->drawable, gc->gc, x, y);
	XFlush(display);
}

void jtkDrawRect(JtkGC *gc, int x, int y, int width, int height)
{
	XDrawRectangle(display, gc->drawable, gc->gc, x, y, width, height);
	XFlush(display);
}

void jtkFillRect(JtkGC *gc, int x, int y, int width, int height)
{
	XFillRectangle(display, gc->drawable, gc->gc, x, y, width, height);
	XFlush(display);
}

void jtkDrawArc(JtkGC *gc, int x, int y, int width, int height,
					int angle1, int angle2)
{
	XDrawArc(display, gc->drawable, gc->gc, x, y, width, height,
				angle1, angle2);
	XFlush(display);
}

void jtkFillArc(JtkGC *gc, int x, int y, int width, int height,
					int angle1, int angle2)
{
	XFillArc(display, gc->drawable, gc->gc, x, y, width, height,
				angle1, angle2);
	XFlush(display);
}

void jtkSetArcMode(JtkGC *gc, JtkArcMode mode)
{
	if(mode == JTK_ARCMODE_PIESLICE)
		XSetArcMode(display, gc->gc, ArcPieSlice);
	if(mode == JTK_ARCMODE_CHORD)
		XSetArcMode(display, gc->gc, ArcChord);
}

void jtkDrawText(JtkGC *gc, int px, int py, char *text, int len)
{
	XRectangle ink, logical;
	
	XmbTextExtents(gc->fs, text, len, &ink, &logical);
	XmbDrawString(display, gc->drawable, gc->fs, gc->gc,
					px - logical.x, py - logical.y, text, len);
	XFlush(display);
}

void jtkDrawTextWC(JtkGC *gc, int px, int py, JtkWChar *text, int len)
{
	XRectangle ink, logical;

	XwcTextExtents(gc->fs, (wchar_t*)text, len, &ink, &logical);
	XwcDrawString(display, gc->drawable, gc->fs, gc->gc,
					px - logical.x, py - logical.y, (wchar_t*)text, len);
	XFlush(display);
}

void jtkGetTextSize(JtkGC *gc, char *text, int len, JtkSize *size)
{
	XRectangle ink, logical;
	
	XmbTextExtents(gc->fs, text, len, &ink, &logical);
	size->width = logical.width;
	size->height = logical.height;
}

void jtkGetTextSizeWC(JtkGC *gc, JtkWChar *text, int len, JtkSize *size)
{
	XRectangle ink, logical;
	
	XwcTextExtents(gc->fs, (wchar_t*)text, len, &ink, &logical);
	size->width = logical.width;
	size->height = logical.height;
}
