#ifndef X11_CORE_H
#define X11_CORE_H

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <wchar.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xlocale.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>
#include <GL/glx.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include "jtk.h"

struct JtkWindow
{
	Window window_id;
	unsigned int event_mask;
	JtkWidget *widget;
	void (*callback)(JtkWindowEvent *event);
	JtkBool top_level;
	
	JtkWindow *next;
};

struct JtkPixmap
{
	Pixmap pixmap_id;
};

struct JtkSurface
{
	Pixmap shm_pixmap_id;
	void *shm_data;
	XShmSegmentInfo shm_info;
};

struct JtkGC
{
	GC gc;
	Drawable drawable;
	XFontSet fs;
};

struct JtkGL
{
	Drawable drawable;
	GLXContext glx_context;
};

extern Display *display;
extern Atom WM_PROTOCOLS;
extern Atom WM_DELETE_WINDOW;

void x11_wlist_init();
void x11_wlist_add_window(JtkWindow *jw);
void x11_wlist_remove_window(JtkWindow *jw);
JtkWindow* x11_wlist_find_window(Window window_id);
unsigned long x11_make_rgb(JtkColor color);

#endif /* X11_CORE_H */
