#ifndef JTK_H
#define JTK_H

/*
	jtk.h
*/

#ifndef NULL
#define NULL 0
#endif /* NULL */

/* Handle */
typedef struct JtkPixmap JtkPixmap;
typedef struct JtkSurface JtkSurface;
typedef struct JtkGC JtkGC;
typedef struct JtkGL JtkGL;
typedef struct JtkWindow JtkWindow;
typedef union JtkWindowEvent JtkWindowEvent;
typedef struct JtkWidgetFunc JtkWidgetFunc;
typedef struct JtkWidget JtkWidget;
typedef union JtkWidgetEvent JtkWidgetEvent;
typedef struct JtkFrame JtkFrame;

struct JtkPixmap;
struct JtkSurface;
struct JtkGC;
struct JtkGL;
struct JtkWindow;
union JtkWindowEvent;
struct JtkWidgetFunc;
struct JtkWidget;
union JtkWidgetEvent;
struct JtkFrame;

/* JtkWChar */
typedef unsigned long JtkWChar;

/* JtkColor */
typedef unsigned long JtkColor;
JtkColor jtkRGB(unsigned char r, unsigned char g, unsigned char b);
JtkColor jtkRGBA(unsigned char r, unsigned char g, unsigned char b, unsigned char a);
unsigned char jtkGetRValue(JtkColor color);
unsigned char jtkGetGValue(JtkColor color);
unsigned char jtkGetBValue(JtkColor color);
unsigned char jtkGetAValue(JtkColor color);

/* Mouse Button */
typedef unsigned int JtkMouseButton;
#define JTK_MOUSE_BUTTON_LEFT		1
#define JTK_MOUSE_BUTTON_MIDDLE		2
#define JTK_MOUSE_BUTTON_RIGHT		3
#define JTK_MOUSE_BUTTON_WHEELUP	4
#define JTK_MOUSE_BUTTON_WHEELDOWN	5

/* Jtk Virtual Keycode (JVK) */
typedef unsigned int JtkKeySym;
#include "jtk-keycode.h"

/* Modifier Key */
typedef unsigned int JtkKeyMask;
#define JTK_KEYMASK_SHIFT	(1<<0)
#define JTK_KEYMASK_LOCK		(1<<1)
#define JTK_KEYMASK_CONTROL	(1<<2)
#define JTK_KEYMASK_MOD1		(1<<3)
#define JTK_KEYMASK_MOD2		(1<<4)
#define JTK_KEYMASK_MOD3		(1<<5)
#define JTK_KEYMASK_MOD4		(1<<6)
#define JTK_KEYMASK_MOD5		(1<<7)
#define JTK_KEYMASK_BUTTON1	(1<<8)
#define JTK_KEYMASK_BUTTON2	(1<<9)
#define JTK_KEYMASK_BUTTON3	(1<<10)
#define JTK_KEYMASK_BUTTON4	(1<<11)
#define JTK_KEYMASK_BUTTON5	(1<<12)

/* JtkBool */
typedef enum JtkBool JtkBool;
enum JtkBool
{
	JTK_FALSE = 0,
	JTK_TRUE = 1,
};

/* JtkError */
typedef enum JtkError JtkError;
enum JtkError
{
	JTK_NOERROR = 0,
	JTK_ERROR = 1,
};

/* JtkLineStyle */
typedef enum JtkLineStyle JtkLineStyle;
enum JtkLineStyle
{
	JTK_LINESTYLE_SOLID,
	JTK_LINESTYLE_ONOFFDASH,
	JTK_LINESTYLE_DOUBLEDASH,
};

/* JtkCapStyle */
typedef enum JtkCapStyle JtkCapStyle;
enum JtkCapStyle
{
	JTK_CAPSTYLE_BUTT,
	JTK_CAPSTYLE_ROUND,
	JTK_CAPSTYLE_PROJECTING,
};

/* JtkJoinStyle */
typedef enum JtkJoinStyle JtkJoinStyle;
enum JtkJoinStyle
{
	JTK_JOINSTYLE_MITER,
	JTK_JOINSTYLE_ROUND,
	JTK_JOINSTYLE_BEVEL,
};

/* JtkArcMode */
typedef enum JtkArcMode JtkArcMode;
enum JtkArcMode
{
	JTK_ARCMODE_PIESLICE,
	JTK_ARCMODE_CHORD,
};

/* JtkPoint */
typedef struct JtkPoint JtkPoint;
struct JtkPoint
{
	int px;
	int py;
};

JtkPoint* jtkSetPoint(JtkPoint *p, int px, int py);

/* JtkSize */
typedef struct JtkSize JtkSize;
struct JtkSize
{
	int width;
	int height;
};

JtkSize* jtkSetSize(JtkSize *s, int width, int height);

/* JtkRect */
typedef struct JtkRect JtkRect;
struct JtkRect
{
	int x;
	int y;
	int width;
	int height;
};

JtkRect* jtkSetRect(JtkRect *r, int x, int y, int width, int height);

/* Initialization and Finalization */
JtkError jtkInit();
void jtkFinal();

/* system */
void* j_malloc(unsigned int size);
void j_free(void *p);
void j_zero(void *data, unsigned int size);
unsigned int j_strlen(const char *text);
unsigned int j_wcslen(const JtkWChar *text);
void j_strcpy(char *dest, const char *src);

/* image */
typedef struct JtkImage JtkImage;
struct JtkImage
{
	int width;
	int height;
	JtkColor *pixel;
};

JtkImage* jtkCreateImage(int width, int height);
void jtkDestroyImage(JtkImage *image);
void jtkPutImage(JtkGC *gc, JtkImage *image,
					int src_x, int src_y, int width, int height,
					int dest_x, int dest_y);
void jtkGetImage(JtkGC *gc, JtkImage *image,
					int src_x, int src_y, int width, int height,
					int dest_x, int dest_y);
void jtkPutPixel(JtkImage *image, JtkColor color, int px, int py);
JtkColor jtkGetPixel(JtkImage *image, int px, int py);
int jtkGetImageWidth(JtkImage *image);
int jtkGetImageHeight(JtkImage *image);
JtkImage* jtkLoadImageFile(char *name);
void jtkSaveImageFile(JtkImage *image, char *name);

/* window */
#define JTK_WINDOW_EVENTMASK_KEYDOWN		(1<<0)
#define JTK_WINDOW_EVENTMASK_KEYUP			(1<<1)
#define JTK_WINDOW_EVENTMASK_BUTTONDOWN	(1<<2)
#define JTK_WINDOW_EVENTMASK_BUTTONUP		(1<<3)
#define JTK_WINDOW_EVENTMASK_MOTION		(1<<4)
#define JTK_WINDOW_EVENTMASK_ENTER			(1<<5)
#define JTK_WINDOW_EVENTMASK_LEAVE			(1<<6)
#define JTK_WINDOW_EVENTMASK_FOCUSIN		(1<<7)
#define JTK_WINDOW_EVENTMASK_FOCUSOUT		(1<<8)
#define JTK_WINDOW_EVENTMASK_CREATE		(1<<9)
#define JTK_WINDOW_EVENTMASK_DESTROY		(1<<10)
#define JTK_WINDOW_EVENTMASK_MAP			(1<<11)
#define JTK_WINDOW_EVENTMASK_UNMAP			(1<<12)
#define JTK_WINDOW_EVENTMASK_MOVE			(1<<13)
#define JTK_WINDOW_EVENTMASK_RESIZE		(1<<14)
#define JTK_WINDOW_EVENTMASK_EXPOSE		(1<<15)

typedef enum JtkWindowEventType JtkWindowEventType;
enum JtkWindowEventType{
	JTK_WINDOW_EVENT_KEYDOWN,
	JTK_WINDOW_EVENT_KEYUP,
	JTK_WINDOW_EVENT_BUTTONDOWN,
	JTK_WINDOW_EVENT_BUTTONUP,
	JTK_WINDOW_EVENT_MOTION,
	JTK_WINDOW_EVENT_ENTER,
	JTK_WINDOW_EVENT_LEAVE,
	JTK_WINDOW_EVENT_FOCUSIN,
	JTK_WINDOW_EVENT_FOCUSOUT,
	JTK_WINDOW_EVENT_CREATE,
	JTK_WINDOW_EVENT_DESTROY,
	JTK_WINDOW_EVENT_MAP,
	JTK_WINDOW_EVENT_UNMAP,
	JTK_WINDOW_EVENT_MOVE,
	JTK_WINDOW_EVENT_RESIZE,
	JTK_WINDOW_EVENT_EXPOSE,
	JTK_WINDOW_EVENT_CLOSE,
};

union JtkWindowEvent
{
	JtkWindowEventType type;
	
	struct{
		JtkWindowEventType type;
		JtkWindow *window;
		JtkWidget *widget;
	}any;

	// type = JTK_WINDOW_EVENT_KEYDOWN
	struct{
		JtkWindowEventType type;
		JtkWindow *window;
		JtkWidget *widget;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
		JtkKeySym keysym;
	}keydown;
	
	// type = JTK_WINDOW_EVENT_KEYUP
	struct{
		JtkWindowEventType type;
		JtkWindow *window;
		JtkWidget *widget;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
		JtkKeySym keysym;
	}keyup;
	
	// type = JTK_WINDOW_EVENT_BUTTONDOWN
	struct{
		JtkWindowEventType type;
		JtkWindow *window;
		JtkWidget *widget;
		int px;
		int py;
		int screen_px;
		int screen_py;
		int button;
		JtkKeyMask keymask;
		JtkKeySym keysym;
	}buttondown;
	
	// type = JTK_WINDOW_EVENT_BUTTONUP
	struct{
		JtkWindowEventType type;
		JtkWindow *window;
		JtkWidget *widget;
		int px;
		int py;
		int screen_px;
		int screen_py;
		int button;
		JtkKeyMask keymask;
		JtkKeySym keysym;
	}buttonup;
	
	// type = JTK_WINDOW_EVENT_MOTION
	struct{
		JtkWindowEventType type;
		JtkWindow *window;
		JtkWidget *widget;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
	}motion;
	
	// type = JTK_WINDOW_EVENT_ENTER
	struct{
		JtkWindowEventType type;
		JtkWindow *window;
		JtkWidget *widget;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
	}enter;
	
	// type = JTK_WINDOW_EVENT_LEAVE
	struct{
		JtkWindowEventType type;
		JtkWindow *window;
		JtkWidget *widget;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
	}leave;
	
	// type = JTK_WINDOW_EVENT_FOCUSIN
	struct{
		JtkWindowEventType type;
		JtkWindow *window;
		JtkWidget *widget;
	}focusin;
	
	// type = JTK_WINDOW_EVENT_FOCUSOUT
	struct{
		JtkWindowEventType type;
		JtkWindow *window;
		JtkWidget *widget;
	}focusout;
	
	// type = JTK_WINDOW_EVENT_CREATE
	struct{
		JtkWindowEventType type;
		JtkWindow *window;
		JtkWidget *widget;
	}create;
	
	// type = JTK_WINDOW_EVENT_DESTROY
	struct{
		JtkWindowEventType type;
		JtkWindow *window;
		JtkWidget *widget;
	}destroy;
	
	// type = JTK_WINDOW_EVENT_MAP
	struct{
		JtkWindowEventType type;
		JtkWindow *window;
		JtkWidget *widget;
	}map;
	
	// type = JTK_WINDOW_EVENT_UNMAP
	struct{
		JtkWindowEventType type;
		JtkWindow *window;
		JtkWidget *widget;
	}unmap;
	
	// type = JTK_WINDOW_EVENT_MOVE
	struct{
		JtkWindowEventType type;
		JtkWindow *window;
		JtkWidget *widget;
		int px;
		int py;
	}move;
	
	// type = JTK_WINDOW_EVENT_RESIZE
	struct{
		JtkWindowEventType type;
		JtkWindow *window;
		JtkWidget *widget;
		int width;
		int height;
	}resize;
	
	// type = JTK_WINDOW_EVENT_EXPOSE
	struct{
		JtkWindowEventType type;
		JtkWindow *window;
		JtkWidget *widget;
		int x;
		int y;
		int width;
		int height;
		int count;
	}expose;
	
	// type = JTK_WINDOW_EVENT_CLOSE
	struct{
		JtkWindowEventType type;
		JtkWindow *window;
		JtkWidget *widget;
	}close;
};

JtkWindow* jtkCreateSimpleWindow(JtkWindow *parent);
void jtkDestroyWindow(JtkWindow *jw);
void jtkMapWindow(JtkWindow *jw);
void jtkUnmapWindow(JtkWindow *jw);
void jtkClearWindow(JtkWindow *jw, int x, int y,
						int width, int height,
						JtkBool exposures);
void jtkRaiseWindow(JtkWindow *jw);
void jtkLowerWindow(JtkWindow *jw);
void jtkSetWindowPos(JtkWindow *jw, int px, int py);
void jtkSetWindowSize(JtkWindow *jw, int width, int height);
void jtkSetWindowColor(JtkWindow *jw, JtkColor color);
void jtkSetWindowBorderSize(JtkWindow *jw, int size);
void jtkSetWindowBorderColor(JtkWindow *jw, JtkColor color);
void jtkSetWindowText(JtkWindow *jw, char *text);
void jtkGetWindowPos(JtkWindow *jw, JtkPoint *pos);
void jtkGetWindowSize(JtkWindow *jw, JtkSize *size);
void jtkSetWindowEventMask(JtkWindow *jw, int mask);
void jtkSetWindowFocus(JtkWindow *jw);

void jtkSetWidget(JtkWindow *jw,
					void (*callback)(JtkWindowEvent *event),
					JtkWidget *widget);


/* JtkWidget */
struct JtkWidgetFunc
{
	JtkWindow* (*get_container)(JtkWidget *widget);
	JtkWindow* (*get_drawing_area)(JtkWidget *widget);
	void (*destroy)(JtkWidget *widget);
	void (*map)(JtkWidget *widget);
	void (*unmap)(JtkWidget *widget);
	void (*raise)(JtkWidget *widget);
	void (*lower)(JtkWidget *widget);
	void (*set_pos)(JtkWidget *widget, int px, int py);
	void (*set_size)(JtkWidget *widget, int width, int height);
	void (*set_color)(JtkWidget *widget, JtkColor color);
	void (*set_border_size)(JtkWidget *widget, int size);
	void (*set_border_color)(JtkWidget *widget, JtkColor color);
	void (*set_text_color)(JtkWidget *widget, JtkColor color);
	void (*set_text_lines)(JtkWidget *widget, int lines);
	void (*set_text)(JtkWidget *widget, char *text);
	void (*clear_text)(JtkWidget *widget);
};

struct JtkWidget
{
	void *widget;
	JtkWidgetFunc *func;
	void (*callback)(JtkWidgetEvent *event);
	void *data;
	JtkBool mapping;
};

typedef unsigned long JtkWidgetEventType;
enum JtkWidgetEventType{
	JTK_WIDGET_EVENT_KEYDOWN,
	JTK_WIDGET_EVENT_KEYUP,
	JTK_WIDGET_EVENT_BUTTONDOWN,
	JTK_WIDGET_EVENT_BUTTONUP,
	JTK_WIDGET_EVENT_MOTION,
	JTK_WIDGET_EVENT_ENTER,
	JTK_WIDGET_EVENT_LEAVE,
	JTK_WIDGET_EVENT_FOCUSIN,
	JTK_WIDGET_EVENT_FOCUSOUT,
	JTK_WIDGET_EVENT_CREATE,
	JTK_WIDGET_EVENT_DESTROY,
	JTK_WIDGET_EVENT_MAP,
	JTK_WIDGET_EVENT_UNMAP,
	JTK_WIDGET_EVENT_MOVE,
	JTK_WIDGET_EVENT_RESIZE,
	JTK_WIDGET_EVENT_EXPOSE,
	JTK_WIDGET_EVENT_CLOSE,
	JTK_WIDGET_EVENT_BUTTONCLICK,
};

union JtkWidgetEvent
{
	JtkWidgetEventType type;
	
	struct{
		JtkWidgetEventType type;
		JtkWidget *widget;
		void *data;
	}any;
	
	// type = JTK_WIDGET_EVENT_KEYDOWN
	struct{
		JtkWidgetEventType type;
		JtkWidget *widget;
		void *data;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
		JtkKeySym keysym;
	}keydown;
	
	// type = JTK_WIDGET_EVENT_KEYUP
	struct{
		JtkWidgetEventType type;
		JtkWidget *widget;
		void *data;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
		JtkKeySym keysym;
	}keyup;
	
	// type = JTK_WIDGET_EVENT_BUTTONDOWN
	struct{
		JtkWidgetEventType type;
		JtkWidget *widget;
		void *data;
		int px;
		int py;
		int screen_px;
		int screen_py;
		int button;
		JtkKeyMask keymask;
		JtkKeySym keysym;
	}buttondown;
	
	// type = JTK_WIDGET_EVENT_BUTTONUP
	struct{
		JtkWidgetEventType type;
		JtkWidget *widget;
		void *data;
		int px;
		int py;
		int screen_px;
		int screen_py;
		int button;
		JtkKeyMask keymask;
		JtkKeySym keysym;
	}buttonup;
	
	// type = JTK_WIDGET_EVENT_MOTION
	struct{
		JtkWidgetEventType type;
		JtkWidget *widget;
		void *data;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
	}motion;
	
	// type = JTK_WIDGET_EVENT_ENTER
	struct{
		JtkWidgetEventType type;
		JtkWidget *widget;
		void *data;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
	}enter;
	
	// type = JTK_WIDGET_EVENT_LEAVE
	struct{
		JtkWidgetEventType type;
		JtkWidget *widget;
		void *data;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
	}leave;
	
	// type = JTK_WIDGET_EVENT_FOCUSIN
	struct{
		JtkWidgetEventType type;
		JtkWidget *widget;
		void *data;
	}focusin;
	
	// type = JTK_WIDGET_EVENT_FOCUSOUT
	struct{
		JtkWidgetEventType type;
		JtkWidget *widget;
		void *data;
	}focusout;
	
	// type = JTK_WIDGET_EVENT_CREATE
	struct{
		JtkWidgetEventType type;
		JtkWidget *widget;
		void *data;
	}create;
	
	// type = JTK_WIDGET_EVENT_DESTROY
	struct{
		JtkWidgetEventType type;
		JtkWidget *widget;
		void *data;
	}destroy;
	
	// type = JTK_WIDGET_EVENT_MAP
	struct{
		JtkWidgetEventType type;
		JtkWidget *widget;
		void *data;
	}map;
	
	// type = JTK_WIDGET_EVENT_UNMAP
	struct{
		JtkWidgetEventType type;
		JtkWidget *widget;
		void *data;
	}unmap;
	
	// type = JTK_WIDGET_EVENT_MOVE
	struct{
		JtkWidgetEventType type;
		JtkWidget *widget;
		void *data;
		int px;
		int py;
	}move;
	
	// type = JTK_WIDGET_EVENT_RESIZE
	struct{
		JtkWidgetEventType type;
		JtkWidget *widget;
		void *data;
		int width;
		int height;
	}resize;
	
	// type = JTK_WIDGET_EVENT_EXPOSE
	struct{
		JtkWidgetEventType type;
		JtkWidget *widget;
		void *data;
		int x;
		int y;
		int width;
		int height;
		int count;
	}expose;
	
	// type = JTK_WIDGET_EVENT_CLOSE
	struct{
		JtkWidgetEventType type;
		JtkWidget *widget;
		void *data;
	}close;
	
	// type = JTK_WIDGET_EVENT_BUTTONCLICK
	struct{
		JtkWidgetEventType type;
		JtkWidget *widget;
		void *data;
	}buttonclick;
};

JtkWidget* jtkCreateWindow(JtkWidget *parent);
JtkWidget* jtkCreateButton(JtkWidget *parent);
JtkWidget* jtkCreateLogbox(JtkWidget *parent);

void jtkDestroyWidget(JtkWidget *widget);
void jtkMapWidget(JtkWidget *widget);
void jtkUnmapWidget(JtkWidget *widget);
void jtkToggleMappingWidget(JtkWidget *widget);
void jtkRaiseWidget(JtkWidget *widget);
void jtkLowerWidget(JtkWidget *widget);
void jtkSetWidgetPos(JtkWidget *widget, int px, int py);
void jtkSetWidgetSize(JtkWidget *widget, int width, int height);
void jtkSetWidgetColor(JtkWidget *widget, JtkColor color);
void jtkSetWidgetBorderSize(JtkWidget *widget, int size);
void jtkSetWidgetBorderColor(JtkWidget *widget, JtkColor color);

void jtkSetWidgetTextColor(JtkWidget *widget, JtkColor color);
void jtkSetWidgetTextLines(JtkWidget *widget, int lines);
void jtkSetWidgetText(JtkWidget *widget, char *text);
void jtkClearWidgetText(JtkWidget *widget);

void jtkSetWidgetCallback(JtkWidget *widget, void *data,
								void (*func)(JtkWidgetEvent *event));

JtkWindow* jtkGetContainer(JtkWidget *widget);
JtkWindow* jtkGetDrawingArea(JtkWidget *widget);

/* frame */
typedef struct JtkFrameFunc JtkFrameFunc;
typedef union JtkFrameEvent JtkFrameEvent;

struct JtkFrameFunc
{
	JtkWindow* (*get_container)(JtkFrame *frame);
	JtkWindow* (*get_drawing_area)(JtkFrame *frame);
	void (*destroy)(JtkFrame *frame);
	void (*map)(JtkFrame *frame);
	void (*unmap)(JtkFrame *frame);
	void (*raise)(JtkFrame *frame);
	void (*lower)(JtkFrame *frame);
	void (*set_pos)(JtkFrame *frame, int px, int py);
	void (*set_size)(JtkFrame *frame, int width, int height);
	void (*set_color)(JtkFrame *frame, JtkColor color);
	void (*set_border_size)(JtkFrame *frame, int size);
	void (*set_border_color)(JtkFrame *frame, JtkColor color);
	void (*set_text_color)(JtkFrame *frame, JtkColor color);
	void (*set_text_lines)(JtkFrame *frame, int lines);
	void (*set_text)(JtkFrame *frame, char *text);
	void (*clear_text)(JtkFrame *frame);
};

struct JtkFrame
{
	void *frame;
	JtkFrameFunc *func;
	void (*callback)(JtkFrameEvent *event);
	void *data;
};

typedef enum JtkFrameEventType JtkFrameEventType;
enum JtkFrameEventType
{
	JTK_FRAME_EVENT_KEYDOWN,
	JTK_FRAME_EVENT_KEYUP,
	JTK_FRAME_EVENT_BUTTONDOWN,
	JTK_FRAME_EVENT_BUTTONUP,
	JTK_FRAME_EVENT_MOTION,
	JTK_FRAME_EVENT_ENTER,
	JTK_FRAME_EVENT_LEAVE,
	JTK_FRAME_EVENT_FOCUSIN,
	JTK_FRAME_EVENT_FOCUSOUT,
	JTK_FRAME_EVENT_CREATE,
	JTK_FRAME_EVENT_DESTROY,
	JTK_FRAME_EVENT_MAP,
	JTK_FRAME_EVENT_UNMAP,
	JTK_FRAME_EVENT_MOVE,
	JTK_FRAME_EVENT_RESIZE,
	JTK_FRAME_EVENT_EXPOSE,
	JTK_FRAME_EVENT_CLOSE,
};

union JtkFrameEvent
{
	JtkFrameEventType type;
	
	struct{
		JtkFrameEventType type;
		JtkFrame *frame;
		void *data;
	}any;
	
	// type = JTK_FRAME_EVENT_KEYDOWN
	struct{
		JtkFrameEventType type;
		JtkFrame *frame;
		void *data;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
		JtkKeySym keysym;
	}keydown;
	
	// type = JTK_FRAME_EVENT_KEYUP
	struct{
		JtkFrameEventType type;
		JtkFrame *frame;
		void *data;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
		JtkKeySym keysym;
	}keyup;
	
	// type = JTK_FRAME_EVENT_BUTTONDOWN
	struct{
		JtkFrameEventType type;
		JtkFrame *frame;
		void *data;
		int px;
		int py;
		int screen_px;
		int screen_py;
		int button;
		JtkKeyMask keymask;
		JtkKeySym keysym;
	}buttondown;
	
	// type = JTK_FRAME_EVENT_BUTTONUP
	struct{
		JtkFrameEventType type;
		JtkFrame *frame;
		void *data;
		int px;
		int py;
		int screen_px;
		int screen_py;
		int button;
		JtkKeyMask keymask;
		JtkKeySym keysym;
	}buttonup;
	
	// type = JTK_FRAME_EVENT_MOTION
	struct{
		JtkFrameEventType type;
		JtkFrame *frame;
		void *data;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
	}motion;
	
	// type = JTK_FRAME_EVENT_ENTER
	struct{
		JtkFrameEventType type;
		JtkFrame *frame;
		void *data;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
	}enter;
	
	// type = JTK_FRAME_EVENT_LEAVE
	struct{
		JtkFrameEventType type;
		JtkFrame *frame;
		void *data;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
	}leave;
	
	// type = JTK_FRAME_EVENT_FOCUSIN
	struct{
		JtkFrameEventType type;
		JtkFrame *frame;
		void *data;
	}focusin;
	
	// type = JTK_FRAME_EVENT_FOCUSOUT
	struct{
		JtkFrameEventType type;
		JtkFrame *frame;
		void *data;
	}focusout;
	
	// type = JTK_FRAME_EVENT_CREATE
	struct{
		JtkFrameEventType type;
		JtkFrame *frame;
		void *data;
	}create;
	
	// type = JTK_FRAME_EVENT_DESTROY
	struct{
		JtkFrameEventType type;
		JtkFrame *frame;
		void *data;
	}destroy;
	
	// type = JTK_FRAME_EVENT_MAP
	struct{
		JtkFrameEventType type;
		JtkWidget *widget;
		void *data;
	}map;
	
	// type = JTK_FRAME_EVENT_UNMAP
	struct{
		JtkFrameEventType type;
		JtkFrame *frame;
		void *data;
	}unmap;
	
	// type = JTK_FRAME_EVENT_MOVE
	struct{
		JtkFrameEventType type;
		JtkFrame *frame;
		void *data;
		int px;
		int py;
	}move;
	
	// type = JTK_FRAME_EVENT_RESIZE
	struct{
		JtkFrameEventType type;
		JtkFrame *frame;
		void *data;
		int width;
		int height;
	}resize;
	
	// type = JTK_FRAME_EVENT_EXPOSE
	struct{
		JtkFrameEventType type;
		JtkFrame *frame;
		void *data;
		int x;
		int y;
		int width;
		int height;
		int count;
	}expose;
	
	// type = JTK_FRAME_EVENT_CLOSE
	struct{
		JtkFrameEventType type;
		JtkFrame *frame;
		void *data;
	}close;
};

JtkFrame* jtkGetRootWindow();
JtkFrame* jtkCreateFrame(JtkFrame *parent);
JtkFrame* jtkCreatePopup(JtkFrame *parent);
JtkFrame* jtkCreatePopupMenu(JtkFrame *parent);
void jtkDestroyFrame(JtkFrame *frame);
void jtkMapFrame(JtkFrame *frame);
void jtkUnmapFrame(JtkFrame *frame);
void jtkRaiseFrame(JtkFrame *frame);
void jtkLowerFrame(JtkFrame *frame);
void jtkSetFramePos(JtkFrame *frame, int px, int py);
void jtkSetFrameSize(JtkFrame *frame, int width, int height);
void jtkSetFrameColor(JtkFrame *frame, JtkColor color);
void jtkSetFrameBorderSize(JtkFrame *frame, int size);
void jtkSetFrameBorderColor(JtkFrame *frame, JtkColor color);
void jtkSetFrameText(JtkFrame *frame, char *text);
void jtkVBoxBegin(JtkFrame *frame);
void jtkHBoxBegin(JtkFrame *frame);
void jtkBoxEnd(JtkFrame *frame);

/* event */
void jtkMain();
void jtkMainQuit();
void jtkSetIdleFunc(void (*idle)(void *data), void *data);
void jtkSleep(unsigned int ms);

/* screen */
int jtkGetScreenWidth();
int jtkGetScreenHeight();
int jtkGetScreenBPP();	/* BPP = Bit per pixel */

/* pixmap */
JtkPixmap* jtkCreateWindowPixmap(JtkWindow *jw, int width, int height);
JtkPixmap* jtkCreatePixmap(JtkWidget *widget, int width, int height);
void jtkDestroyPixmap(JtkPixmap *pixmap);

/* surface */
JtkSurface* jtkCreateWindowSurface(JtkWindow *jw, int width, int height);
JtkSurface* jtkCreateSurface(JtkWidget *widget, int width, int height);
void jtkDestroySurface(JtkSurface *surface);
void* jtkLockSurface(JtkSurface *surface);
void jtkUnlockSurface(JtkSurface *surface);

/* graphics */
JtkGC* jtkCreateWindowGC(JtkWindow *jw);
JtkGC* jtkCreateGC(JtkWidget *widget);
JtkGC* jtkCreatePixmapGC(JtkPixmap *pixmap);
JtkGC* jtkCreateSurfaceGC(JtkSurface *surface);
void jtkDestroyGC(JtkGC *gc);
void jtkBitBlt(JtkGC *src, JtkGC *dest, int src_x, int src_y,
					int width, int height, int dest_x, int dest_y);
void jtkSetColor(JtkGC *gc, JtkColor color);
void jtkSetBackColor(JtkGC *gc, JtkColor color);
void jtkSetLineAttributes(JtkGC *gc, unsigned int size,
								JtkLineStyle line_style,
								JtkCapStyle cap_style,
								JtkJoinStyle join_style);
void jtkSetDashes(JtkGC *gc, int offset, char dash_list[], int n);
void jtkDrawLine(JtkGC *gc, int x1, int y1, int x2, int y2);
void jtkDrawPoint(JtkGC *gc, int x, int y);
void jtkDrawRect(JtkGC *gc, int x, int y, int width, int height);
void jtkFillRect(JtkGC *gc, int x, int y, int width, int height);
void jtkDrawArc(JtkGC *gc, int x, int y, int width, int height,
					int angle1, int angle2);
void jtkFillArc(JtkGC *gc, int x, int y, int width, int height,
					int angle1, int angle2);
void jtkSetArcMode(JtkGC *gc, JtkArcMode mode);
void jtkDrawText(JtkGC *gc, int px, int py, char *text, int len);
void jtkDrawTextWC(JtkGC *gc, int px, int py, JtkWChar *text, int len);
void jtkGetTextSize(JtkGC *gc, char *text, int len, JtkSize *size);
void jtkGetTextSizeWC(JtkGC *gc, JtkWChar *text, int len, JtkSize *size);

/* gl */
JtkGL* jtkGLCreateWindow(JtkWindow *jw);
JtkGL* jtkGLCreate(JtkWidget *widget);
void jtkGLDestroy(JtkGL *gl);
void jtkGLCurrent(JtkGL *gl);
void jtkGLSwapBuffers(JtkGL *gl);

/* Multi-Thread */
typedef struct JtkThread JtkThread;
struct JtkThread;
typedef struct JtkSemaphore JtkSemaphore;
struct JtkSemaphore;
typedef struct JtkMutex JtkMutex;
struct JtkMutex;

JtkThread* jtkCreateThread(void (*func)(void *data), void *data);
void jtkKillThread(JtkThread *thread);
void jtkWaitThread(JtkThread *thread);
void jtkExitThread();
JtkSemaphore* jtkCreateSemaphore(unsigned int value);
JtkError jtkPostSemaphore(JtkSemaphore *sem);
JtkError jtkWaitSemaphore(JtkSemaphore *sem);
JtkError jtkDestroySemaphore(JtkSemaphore *sem);
JtkMutex* jtkCreateMutex();
JtkError jtkLockMutex(JtkMutex *mutex);
JtkError jtkUnlockMutex(JtkMutex *mutex);
JtkError jtkDestroyMutex(JtkMutex *mutex);

/* Timer */
typedef struct JtkTimer JtkTimer;
struct JtkTimer;

JtkTimer* jtkCreateTimer(unsigned int ms, void (*callback)(void *data), void *data);
void jtkDestroyTimer(JtkTimer *timer);

/* Joystick */
typedef enum JtkJoystickEventType JtkJoystickEventType;
enum JtkJoystickEventType
{
	JTK_JOYSTICK_EVENT_BUTTON,
	JTK_JOYSTICK_EVENT_AXIS,
};

typedef struct JtkJoystick JtkJoystick;
struct JtkJoystick;

typedef struct JtkJoystickEvent JtkJoystickEvent;
struct JtkJoystickEvent
{
	JtkJoystickEventType type;
	
	struct{
		JtkJoystickEventType type;
		JtkJoystick *joystick;
		void *data;
	}any;
	
	struct{
		JtkJoystickEventType type;
		JtkJoystick *joystick;
		void *data;
		int number;
		int state;
	}button;
	
	struct{
		JtkJoystickEventType type;
		JtkJoystick *joystick;
		void *data;
		int number;
		short value;
	}axis;
};

JtkJoystick* jtkOpenJoystick(int id);
void jtkCloseJoystick(JtkJoystick *joystick);
void jtkSetJoystickCallback(JtkJoystick *joystick, void *data,
								void (*callback)(JtkJoystickEvent *event));
void jtkUpdateJoystick(JtkJoystick *joystick);
char* jtkGetJoystickName(JtkJoystick *joystick);
int jtkGetJoystickAxisNum(JtkJoystick *joystick);
int jtkGetJoystickButtonNum(JtkJoystick *joystick);
short jtkGetJoystickAxis(JtkJoystick *joystick, int axis);
int jtkGetJoystickButton(JtkJoystick *joystick, int button);

/* Audio */

/* Network */

#endif /* JTK_H */
