/*
	jtk.c
*/

#include "jtk.h"

/* color */
JtkColor jtkRGB(unsigned char r, unsigned char g, unsigned char b)
{
	JtkColor color;
	
	color = r;
	color <<= 8;
	color |= g;
	color <<= 8;
	color |= b;
	color <<= 8;
	
	return color;
}

JtkColor jtkRGBA(unsigned char r, unsigned char g, unsigned char b, unsigned char a)
{
	JtkColor color;
	
	color = r;
	color <<= 8;
	color |= g;
	color <<= 8;
	color |= b;
	color <<= 8;
	color |= a;
	
	return color;
}

unsigned char jtkGetRValue(JtkColor color)
{
	color >>= 24;
	return color;
}

unsigned char jtkGetGValue(JtkColor color)
{
	color >>= 16;
	return color;
}

unsigned char jtkGetBValue(JtkColor color)
{
	color >>= 8;
	return color;
}

unsigned char jtkGetAValue(JtkColor color)
{
	return color;
}

/* Utility */
JtkPoint* jtkSetPoint(JtkPoint *p, int px, int py)
{
	p->px = px;
	p->py = py;
	return p;
}

JtkSize* jtkSetSize(JtkSize *s, int width, int height)
{
	s->width = width;
	s->height = height;
	return s;
}

JtkRect* jtkSetRect(JtkRect *r, int x, int y, int width, int height)
{
	r->x = x;
	r->y = y;
	r->width = width;
	r->height = height;
	return r;
}

/* jtk widget */
void jtkDestroyWidget(JtkWidget *widget)
{
	JtkWidgetEvent jwe;

	if(widget->func == NULL)
		if(widget->func->destroy == NULL)
			widget->func->destroy(widget);
	
	jwe.type = JTK_WIDGET_EVENT_DESTROY;
	jwe.any.widget = widget;
	jwe.any.data = widget->data;
	if(widget->callback != NULL)
		widget->callback(&jwe);
	j_free(widget);
}

void jtkMapWidget(JtkWidget *widget)
{
	if(widget->func == NULL)
		return;
	if(widget->func->map == NULL)
		return;
	
	widget->func->map(widget);
	widget->mapping = JTK_TRUE;
}

void jtkUnmapWidget(JtkWidget *widget)
{
	if(widget->func == NULL)
		return;
	if(widget->func->unmap == NULL)
		return;
	
	widget->func->unmap(widget);
	widget->mapping = JTK_FALSE;
}

void jtkToggleMappingWidget(JtkWidget *widget)
{
	if(widget->mapping == JTK_TRUE)
		jtkUnmapWidget(widget);
	else
		jtkMapWidget(widget);
}

void jtkRaiseWidget(JtkWidget *widget)
{
	if(widget->func == NULL)
		return;
	if(widget->func->raise == NULL)
		return;
	
	widget->func->raise(widget);
}

void jtkLowerWidget(JtkWidget *widget)
{
	if(widget->func == NULL)
		return;
	if(widget->func->lower == NULL)
		return;
	
	widget->func->lower(widget);
}

void jtkSetWidgetPos(JtkWidget *widget, int px, int py)
{
	if(widget->func == NULL)
		return;
	if(widget->func->set_pos == NULL)
		return;
	
	widget->func->set_pos(widget, px, py);
}

void jtkSetWidgetSize(JtkWidget *widget, int width, int height)
{
	if(widget->func == NULL)
		return;
	if(widget->func->set_size == NULL)
		return;
	
	widget->func->set_size(widget, width, height);
}

void jtkSetWidgetBorderSize(JtkWidget *widget, int size)
{
	if(widget->func == NULL)
		return;
	if(widget->func->set_border_size == NULL)
		return;
	
	widget->func->set_border_size(widget, size);
}

void jtkSetWidgetColor(JtkWidget *widget, JtkColor color)
{
	if(widget->func == NULL)
		return;
	if(widget->func->set_color == NULL)
		return;
	
	widget->func->set_color(widget, color);
}

void jtkSetWidgetBorderColor(JtkWidget *widget, JtkColor color)
{
	if(widget->func == NULL)
		return;
	if(widget->func->set_border_color == NULL)
		return;
	
	widget->func->set_border_color(widget, color);
}

void jtkSetWidgetTextColor(JtkWidget *widget, JtkColor color)
{
	if(widget->func == NULL)
		return;
	if(widget->func->set_text_color == NULL)
		return;
	
	widget->func->set_text_color(widget, color);
}

void jtkSetWidgetTextLines(JtkWidget *widget, int lines)
{
	if(widget->func == NULL)
		return;
	if(widget->func->set_text_lines == NULL)
		return;
	
	widget->func->set_text_lines(widget, lines);
}

void jtkSetWidgetText(JtkWidget *widget, char *text)
{
	if(widget->func == NULL)
		return;
	if(widget->func->set_text == NULL)
		return;
	
	widget->func->set_text(widget, text);
}

void jtkClearWidgetText(JtkWidget *widget)
{
	if(widget->func == NULL)
		return;
	if(widget->func->clear_text == NULL)
		return;
	
	widget->func->clear_text(widget);
}

void jtkSetWidgetCallback(JtkWidget *widget, void *data,
								void (*callback)(JtkWidgetEvent *event))
{
	widget->data = data;
	widget->callback = callback;
}

JtkWindow* jtkGetContainer(JtkWidget *widget)
{
	if(widget == NULL)
		return NULL;
	if(widget->func == NULL)
		return NULL;
	if(widget->func->get_container == NULL)
		return NULL;
	
	return widget->func->get_container(widget);
}

JtkWindow* jtkGetDrawingArea(JtkWidget *widget)
{
	if(widget == NULL)
		return NULL;
	if(widget->func == NULL)
		return NULL;
	if(widget->func->get_drawing_area == NULL)
		return NULL;
	
	return widget->func->get_drawing_area(widget);
}
