#ifndef X11_CORE_H
#define X11_CORE_H

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <wchar.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xlocale.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>
#include <GL/glx.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include "jtk.h"
#include "jwk.h"

struct JwkWindow
{
	Window window_id;
	unsigned int event_mask;
	XIC xic;
	JtkWidget *widget;
	void (*callback)(JwkEvent *event);
	JtkBool top_level;
	
	JwkWindow *next;
};

struct JtkGC
{
	JtkGCMode mode;
	JtkGCType type;
	
	JwkWindow *jw;

	GC gc;
	Drawable *drawable;
	Drawable screen;
	Drawable buffer;
	int buffer_width;
	int buffer_height;
	XFontSet fs;
	unsigned int line_size;
	int line_style;
	int cap_style;
	int join_style;
	
	void (*destroy_gc)(JtkGC *gc);
	
	/* Surface */
	void *data_addr;
	XShmSegmentInfo shminfo;
	int bytes_per_line;
	int bytes_per_pixel;
	
	/* GL */
	GLXContext glx_context;
};

extern Display *display;
extern XIM xim;
extern Atom WM_PROTOCOLS;
extern Atom WM_DELETE_WINDOW;

void x11_wlist_init();
void x11_wlist_add_window(JwkWindow *jw);
void x11_wlist_remove_window(JwkWindow *jw);
JwkWindow* x11_wlist_find_window(Window window_id);
unsigned long x11_make_rgb(JtkColor color);

#endif /* X11_CORE_H */
