#ifndef JWK_H
#define JWK_H

#include "jtk.h"

/* window */
#define JWK_EVENTMASK_KEYDOWN		(1<<0)
#define JWK_EVENTMASK_KEYUP			(1<<1)
#define JWK_EVENTMASK_BUTTONDOWN	(1<<2)
#define JWK_EVENTMASK_BUTTONUP		(1<<3)
#define JWK_EVENTMASK_MOTION			(1<<4)
#define JWK_EVENTMASK_ENTER			(1<<5)
#define JWK_EVENTMASK_LEAVE			(1<<6)
#define JWK_EVENTMASK_FOCUSIN		(1<<7)
#define JWK_EVENTMASK_FOCUSOUT		(1<<8)
#define JWK_EVENTMASK_CREATE			(1<<9)
#define JWK_EVENTMASK_DESTROY		(1<<10)
#define JWK_EVENTMASK_MAP			(1<<11)
#define JWK_EVENTMASK_UNMAP			(1<<12)
#define JWK_EVENTMASK_MOVE			(1<<13)
#define JWK_EVENTMASK_RESIZE			(1<<14)
#define JWK_EVENTMASK_EXPOSE			(1<<15)
#define JWK_EVENTMASK_STRING			(1<<16)

typedef enum JwkEventType JwkEventType;
enum JwkEventType{
	JWK_EVENT_KEYDOWN,
	JWK_EVENT_KEYUP,
	JWK_EVENT_BUTTONDOWN,
	JWK_EVENT_BUTTONUP,
	JWK_EVENT_MOTION,
	JWK_EVENT_ENTER,
	JWK_EVENT_LEAVE,
	JWK_EVENT_FOCUSIN,
	JWK_EVENT_FOCUSOUT,
	JWK_EVENT_CREATE,
	JWK_EVENT_DESTROY,
	JWK_EVENT_MAP,
	JWK_EVENT_UNMAP,
	JWK_EVENT_MOVE,
	JWK_EVENT_RESIZE,
	JWK_EVENT_EXPOSE,
	JWK_EVENT_CLOSE,
	JWK_EVENT_STRING,
};

typedef struct JwkWindow JwkWindow;
struct JwkWindow;

typedef union JwkEvent JwkEvent;
union JwkEvent
{
	JwkEventType type;
	
	struct{
		JwkEventType type;
		JwkWindow *window;
		JtkWidget *widget;
	}any;

	// type = JWK_EVENT_KEYDOWN
	struct{
		JwkEventType type;
		JwkWindow *window;
		JtkWidget *widget;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
		JtkKeySym keysym;
	}keydown;
	
	// type = JWK_EVENT_KEYUP
	struct{
		JwkEventType type;
		JwkWindow *window;
		JtkWidget *widget;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
		JtkKeySym keysym;
	}keyup;
	
	// type = JWK_EVENT_BUTTONDOWN
	struct{
		JwkEventType type;
		JwkWindow *window;
		JtkWidget *widget;
		int px;
		int py;
		int screen_px;
		int screen_py;
		int button;
		JtkKeyMask keymask;
		JtkKeySym keysym;
	}buttondown;
	
	// type = JWK_EVENT_BUTTONUP
	struct{
		JwkEventType type;
		JwkWindow *window;
		JtkWidget *widget;
		int px;
		int py;
		int screen_px;
		int screen_py;
		int button;
		JtkKeyMask keymask;
		JtkKeySym keysym;
	}buttonup;
	
	// type = JWK_EVENT_MOTION
	struct{
		JwkEventType type;
		JwkWindow *window;
		JtkWidget *widget;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
	}motion;
	
	// type = JWK_EVENT_ENTER
	struct{
		JwkEventType type;
		JwkWindow *window;
		JtkWidget *widget;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
	}enter;
	
	// type = JWK_EVENT_LEAVE
	struct{
		JwkEventType type;
		JwkWindow *window;
		JtkWidget *widget;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
	}leave;
	
	// type = JWK_EVENT_FOCUSIN
	struct{
		JwkEventType type;
		JwkWindow *window;
		JtkWidget *widget;
	}focusin;
	
	// type = JWK_EVENT_FOCUSOUT
	struct{
		JwkEventType type;
		JwkWindow *window;
		JtkWidget *widget;
	}focusout;
	
	// type = JWK_EVENT_CREATE
	struct{
		JwkEventType type;
		JwkWindow *window;
		JtkWidget *widget;
	}create;
	
	// type = JWK_EVENT_DESTROY
	struct{
		JwkEventType type;
		JwkWindow *window;
		JtkWidget *widget;
	}destroy;
	
	// type = JWK_EVENT_MAP
	struct{
		JwkEventType type;
		JwkWindow *window;
		JtkWidget *widget;
	}map;
	
	// type = JWK_EVENT_UNMAP
	struct{
		JwkEventType type;
		JwkWindow *window;
		JtkWidget *widget;
	}unmap;
	
	// type = JWK_EVENT_MOVE
	struct{
		JwkEventType type;
		JwkWindow *window;
		JtkWidget *widget;
		int px;
		int py;
	}move;
	
	// type = JWK_EVENT_RESIZE
	struct{
		JwkEventType type;
		JwkWindow *window;
		JtkWidget *widget;
		int width;
		int height;
	}resize;
	
	// type = JWK_EVENT_EXPOSE
	struct{
		JwkEventType type;
		JwkWindow *window;
		JtkWidget *widget;
		int x;
		int y;
		int width;
		int height;
		int count;
	}expose;
	
	// type = JWK_EVENT_CLOSE
	struct{
		JwkEventType type;
		JwkWindow *window;
		JtkWidget *widget;
	}close;
	
	// type = JWK_EVENT_STRING
	struct{
		JwkEventType type;
		JwkWindow *window;
		JtkWidget *widget;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
		char *str;
		int len;
	}string;
};

typedef struct JwkWidgetFunc JwkWidgetFunc;
struct JwkWidgetFunc
{
	JwkWindow* (*get_container)(JtkWidget *widget);
	JwkWindow* (*get_frame)(JtkWidget *widget);
	JtkGC* (*create_gc)(JtkWidget *widget, JtkGCMode mode, JtkGCType type);
	void (*destroy)(JtkWidget *widget);
	void (*map)(JtkWidget *widget);
	void (*unmap)(JtkWidget *widget);
	void (*clear)(JtkWidget *widget,
		int px, int py, int width, int height, JtkBool exposures);
	void (*raise)(JtkWidget *widget);
	void (*lower)(JtkWidget *widget);
	void (*set_pos)(JtkWidget *widget, int px, int py);
	void (*set_size)(JtkWidget *widget, int width, int height);
	void (*get_pos)(JtkWidget *widget, JtkPoint *point);
	void (*get_size)(JtkWidget *widget, JtkSize *size);
	void (*set_color)(JtkWidget *widget, JtkColor color);
	void (*set_border_size)(JtkWidget *widget, int size);
	void (*set_border_color)(JtkWidget *widget, JtkColor color);
	void (*set_text_color)(JtkWidget *widget, JtkColor color);
	void (*set_text_lines)(JtkWidget *widget, int lines);
	void (*set_text)(JtkWidget *widget, char *text);
	char* (*get_text)(JtkWidget *widget);
	void (*clear_text)(JtkWidget *widget);
	void (*set_focus)(JtkWidget *widget);
};

struct JtkWidget
{
	void *widget;
	JwkWidgetFunc *func;
	void (*callback)(JtkEvent *event);
	void *data;
};

JwkWindow* jwkCreateWindow(JwkWindow *parent);
JwkWindow* jwkGetContainer(JtkWidget *widget);
JwkWindow* jwkGetFrame(JtkWidget *widget);

JtkGC* jwkCreateGC(JwkWindow *jw, JtkGCMode mode, JtkGCType type);
void jwkDestroyWindow(JwkWindow *jw);
void jwkMapWindow(JwkWindow *jw);
void jwkUnmapWindow(JwkWindow *jw);
void jwkClearWindow(JwkWindow *jw,
	int x, int y, int width, int height, JtkBool exposures);
void jwkRaiseWindow(JwkWindow *jw);
void jwkLowerWindow(JwkWindow *jw);
void jwkSetWindowPos(JwkWindow *jw, int px, int py);
void jwkSetWindowSize(JwkWindow *jw, int width, int height);
void jwkSetWindowColor(JwkWindow *jw, JtkColor color);
void jwkSetWindowBorderSize(JwkWindow *jw, int size);
void jwkSetWindowBorderColor(JwkWindow *jw, JtkColor color);
void jwkSetWindowText(JwkWindow *jw, char *text);
void jwkGetWindowPos(JwkWindow *jw, JtkPoint *pos);
void jwkGetWindowSize(JwkWindow *jw, JtkSize *size);
void jwkSetWindowEventMask(JwkWindow *jw, int mask);
void jwkSetWidget(JwkWindow *jw,
					void (*callback)(JwkEvent *event),
					JtkWidget *widget);
void jwkSetFocus(JwkWindow *jw);
JwkWindow* jwkGetFocus();

#endif /* JWK_H */
