/*
	jtk.c
*/

#include "jtk.h"
#include "jwk.h"

/* color */
JtkColor jtkRGB(unsigned char r, unsigned char g, unsigned char b)
{
	JtkColor color;
	
	color = r;
	color <<= 8;
	color |= g;
	color <<= 8;
	color |= b;
	color <<= 8;
	
	return color;
}

JtkColor jtkRGBA(unsigned char r, unsigned char g, unsigned char b, unsigned char a)
{
	JtkColor color;
	
	color = r;
	color <<= 8;
	color |= g;
	color <<= 8;
	color |= b;
	color <<= 8;
	color |= a;
	
	return color;
}

unsigned char jtkGetRValue(JtkColor color)
{
	color >>= 24;
	return color;
}

unsigned char jtkGetGValue(JtkColor color)
{
	color >>= 16;
	return color;
}

unsigned char jtkGetBValue(JtkColor color)
{
	color >>= 8;
	return color;
}

unsigned char jtkGetAValue(JtkColor color)
{
	return color;
}

/* Utility */
JtkPoint* jtkSetPoint(JtkPoint *p, int px, int py)
{
	if(p == NULL)
		return NULL;

	p->px = px;
	p->py = py;
	return p;
}

JtkSize* jtkSetSize(JtkSize *s, int width, int height)
{
	if(s == NULL)
		return NULL;

	s->width = width;
	s->height = height;
	return s;
}

JtkRect* jtkSetRect(JtkRect *r, int x, int y, int width, int height)
{
	if(r == NULL)
		return NULL;

	r->x = x;
	r->y = y;
	r->width = width;
	r->height = height;
	return r;
}

/* jtk widget */
void jtkSetWidgetCallback(JtkWidget *widget, void *data,
								void (*callback)(JtkEvent *event))
{
	if(widget == NULL)
		return;
	widget->data = data;
	widget->callback = callback;
}

JtkWidget* jtkGetFocus()
{
	return NULL;
}

JwkWindow* jwkGetContainer(JtkWidget *widget)
{
	if(widget == NULL)
		return NULL;
	if(widget->func == NULL)
		return NULL;
	if(widget->func->get_container == NULL)
		return NULL;
	
	return widget->func->get_container(widget);
}

JwkWindow* jwkGetFrame(JtkWidget *widget)
{
	if(widget == NULL)
		return NULL;
	if(widget->func == NULL)
		return NULL;
	if(widget->func->get_frame == NULL)
		return NULL;
	
	return widget->func->get_frame(widget);
}

JtkGC* jtkCreateGC(JtkWidget *widget, JtkGCMode mode, JtkGCType type)
{
	if(widget == NULL)
		return NULL;
	if(widget->func == NULL)
		return NULL;
	if(widget->func->create_gc == NULL)
		return NULL;
	
	return widget->func->create_gc(widget, mode, type);
}

void jtkDestroyWidget(JtkWidget *widget)
{
	JtkEvent je;
	
	if(widget == NULL)
		return;
	
	je.type = JTK_EVENT_DESTROY;
	je.any.widget = widget;
	je.any.data = widget->data;
	if(widget->callback != NULL)
		widget->callback(&je);
	if(widget->func != NULL){
		if(widget->func->destroy != NULL){
			widget->func->destroy(widget);
		}
	}
	j_free(widget);
}
void jtkMapWidget(JtkWidget *widget)
{
	if(widget == NULL)
		return;
	if(widget->func == NULL)
		return;
	if(widget->func->map == NULL)
		return;
	
	widget->func->map(widget);
}

void jtkUnmapWidget(JtkWidget *widget)
{
	if(widget == NULL)
		return;
	if(widget->func == NULL)
		return;
	if(widget->func->unmap == NULL)
		return;
	
	widget->func->unmap(widget);
}

void jtkClearWidget(JtkWidget *widget,
	int px, int py, int width, int height, JtkBool exposures)
{
	if(widget == NULL)
		return;
	if(widget->func == NULL)
		return;
	if(widget->func->clear == NULL)
		return;
	
	widget->func->clear(widget, px, py, width, height, exposures);
}

void jtkRaiseWidget(JtkWidget *widget)
{
	if(widget == NULL)
		return;
	if(widget->func == NULL)
		return;
	if(widget->func->raise == NULL)
		return;
	
	widget->func->raise(widget);
}

void jtkLowerWidget(JtkWidget *widget)
{
	if(widget == NULL)
		return;
	if(widget->func == NULL)
		return;
	if(widget->func->lower == NULL)
		return;
	
	widget->func->lower(widget);
}

void jtkSetWidgetPos(JtkWidget *widget, int px, int py)
{
	if(widget == NULL)
		return;
	if(widget->func == NULL)
		return;
	if(widget->func->set_pos == NULL)
		return;
	
	widget->func->set_pos(widget, px, py);
}

void jtkSetWidgetSize(JtkWidget *widget, int width, int height)
{
	if(widget == NULL)
		return;
	if(widget->func == NULL)
		return;
	if(widget->func->set_size == NULL)
		return;
	
	widget->func->set_size(widget, width, height);
}

void jtkGetWidgetPos(JtkWidget *widget, JtkPoint *point)
{
	if(widget == NULL)
		return;
	if(widget->func == NULL)
		return;
	if(widget->func->get_pos == NULL)
		return;
	if(point == NULL)
		return;
	
	widget->func->get_pos(widget, point);
}

void jtkGetWidgetSize(JtkWidget *widget, JtkSize *size)
{
	if(widget == NULL)
		return;
	if(widget->func == NULL)
		return;
	if(widget->func->get_size == NULL)
		return;
	if(size == NULL)
		return;
	
	widget->func->get_size(widget, size);
}

void jtkSetWidgetBorderSize(JtkWidget *widget, int size)
{
	if(widget == NULL)
		return;
	if(widget->func == NULL)
		return;
	if(widget->func->set_border_size == NULL)
		return;
	
	widget->func->set_border_size(widget, size);
}

void jtkSetWidgetColor(JtkWidget *widget, JtkColor color)
{
	if(widget == NULL)
		return;
	if(widget->func == NULL)
		return;
	if(widget->func->set_color == NULL)
		return;
	
	widget->func->set_color(widget, color);
}

void jtkSetWidgetBorderColor(JtkWidget *widget, JtkColor color)
{
	if(widget == NULL)
		return;
	if(widget->func == NULL)
		return;
	if(widget->func->set_border_color == NULL)
		return;
	
	widget->func->set_border_color(widget, color);
}

void jtkSetWidgetTextColor(JtkWidget *widget, JtkColor color)
{
	if(widget == NULL)
		return;
	if(widget->func == NULL)
		return;
	if(widget->func->set_text_color == NULL)
		return;
	
	widget->func->set_text_color(widget, color);
}

void jtkSetWidgetTextLines(JtkWidget *widget, int lines)
{
	if(widget == NULL)
		return;
	if(widget->func == NULL)
		return;
	if(widget->func->set_text_lines == NULL)
		return;
	
	widget->func->set_text_lines(widget, lines);
}

void jtkSetWidgetText(JtkWidget *widget, char *text)
{
	if(widget == NULL)
		return;
	if(widget->func == NULL)
		return;
	if(widget->func->set_text == NULL)
		return;
	
	widget->func->set_text(widget, text);
}

char* jtkGetWidgetText(JtkWidget *widget)
{
	if(widget == NULL)
		return NULL;
	if(widget->func == NULL)
		return NULL;
	if(widget->func->get_text == NULL)
		return NULL;
	
	return widget->func->get_text(widget);
}

void jtkClearWidgetText(JtkWidget *widget)
{
	if(widget == NULL)
		return;
	if(widget->func == NULL)
		return;
	if(widget->func->clear_text == NULL)
		return;
	
	widget->func->clear_text(widget);
}

void jtkSetFocus(JtkWidget *widget)
{
	if(widget == NULL)
		return;
	if(widget->func == NULL)
		return;
	if(widget->func->set_focus == NULL)
		return;
	
	widget->func->set_focus(widget);
}
