/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParseException;
import org.springframework.util.Assert;

public abstract class NumberUtils {
    public static Number convertNumberToTargetClass(Number number, Class targetClass) throws IllegalArgumentException {
        Assert.notNull(number, "Number must not be null");
        Assert.notNull(targetClass, "Target class must not be null");
        if (targetClass.isInstance(number)) {
            return number;
        }
        if (targetClass.equals(Byte.class)) {
            long value = number.longValue();
            if (value < -128L || value > 127L) {
                NumberUtils.raiseOverflowException(number, targetClass);
            }
            return new Byte(number.byteValue());
        }
        if (targetClass.equals(Short.class)) {
            long value = number.longValue();
            if (value < -32768L || value > 32767L) {
                NumberUtils.raiseOverflowException(number, targetClass);
            }
            return new Short(number.shortValue());
        }
        if (targetClass.equals(Integer.class)) {
            long value = number.longValue();
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                NumberUtils.raiseOverflowException(number, targetClass);
            }
            return new Integer(number.intValue());
        }
        if (targetClass.equals(Long.class)) {
            return new Long(number.longValue());
        }
        if (targetClass.equals(Float.class)) {
            return new Float(number.floatValue());
        }
        if (targetClass.equals(Double.class)) {
            return new Double(number.doubleValue());
        }
        if (targetClass.equals(BigInteger.class)) {
            return BigInteger.valueOf(number.longValue());
        }
        if (targetClass.equals(BigDecimal.class)) {
            return new BigDecimal(number.toString());
        }
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to unknown target class [" + targetClass.getName() + "]");
    }

    private static void raiseOverflowException(Number number, Class targetClass) {
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to target class [" + targetClass.getName() + "]: overflow");
    }

    public static Number parseNumber(String text, Class targetClass) {
        Assert.notNull(text, "Text must not be null");
        Assert.notNull(targetClass, "Target class must not be null");
        String trimmed = text.trim();
        if (targetClass.equals(Byte.class)) {
            return NumberUtils.isHexNumber(trimmed) ? Byte.decode(trimmed) : Byte.valueOf(trimmed);
        }
        if (targetClass.equals(Short.class)) {
            return NumberUtils.isHexNumber(trimmed) ? Short.decode(trimmed) : Short.valueOf(trimmed);
        }
        if (targetClass.equals(Integer.class)) {
            return NumberUtils.isHexNumber(trimmed) ? Integer.decode(trimmed) : Integer.valueOf(trimmed);
        }
        if (targetClass.equals(Long.class)) {
            return NumberUtils.isHexNumber(trimmed) ? Long.decode(trimmed) : Long.valueOf(trimmed);
        }
        if (targetClass.equals(BigInteger.class)) {
            return NumberUtils.isHexNumber(trimmed) ? NumberUtils.decodeBigInteger(trimmed) : new BigInteger(trimmed);
        }
        if (targetClass.equals(Float.class)) {
            return Float.valueOf(trimmed);
        }
        if (targetClass.equals(Double.class)) {
            return Double.valueOf(trimmed);
        }
        if (targetClass.equals(BigDecimal.class) || targetClass.equals(Number.class)) {
            return new BigDecimal(trimmed);
        }
        throw new IllegalArgumentException("Cannot convert String [" + text + "] to target class [" + targetClass.getName() + "]");
    }

    public static Number parseNumber(String text, Class targetClass, NumberFormat numberFormat) {
        if (numberFormat != null) {
            Assert.notNull(text, "Text must not be null");
            Assert.notNull(targetClass, "Target class must not be null");
            try {
                Number number = numberFormat.parse(text.trim());
                return NumberUtils.convertNumberToTargetClass(number, targetClass);
            }
            catch (ParseException ex) {
                IllegalArgumentException iae = new IllegalArgumentException("Could not parse number: " + ex.getMessage());
                iae.initCause(ex);
                throw iae;
            }
        }
        return NumberUtils.parseNumber(text, targetClass);
    }

    private static boolean isHexNumber(String value) {
        int index = value.startsWith("-") ? 1 : 0;
        return value.startsWith("0x", index) || value.startsWith("0X", index) || value.startsWith("#", index);
    }

    private static BigInteger decodeBigInteger(String value) {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (value.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (value.startsWith("0x", index) || value.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (value.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (value.startsWith("0", index) && value.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        BigInteger result = new BigInteger(value.substring(index), radix);
        return negative ? result.negate() : result;
    }
}

