/*
 * Copyright 2008 Hidekatsu Izuno
 * Distributed under the terms of either:
 * - the common development and distribution license (CDDL), v1.0; or
 * - the GNU Lesser General Public License, v2.1 or later
 */
package winstone.classLoader;

import java.io.File;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;

import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.Attributes;

import winstone.Logger;

public class DevLoaderUtil {
    public static URL[] appendClassPathes(URL[] urls) {
    	File root = new File(".");
    	File classPathFile = null;
    	try {
	    	do {
	    		classPathFile = new File(root, ".classpath");
	    		if (classPathFile.exists() && classPathFile.isFile()) {
	     			break;
	    		}
	    		root = root.getParentFile();
	    	} while (root != null);
    	} catch (SecurityException e) {
    		classPathFile = null;
    	}
	    if (classPathFile == null) return urls;
    	
    	final Set<URL> classpathList = new LinkedHashSet<URL>();
    	final File rootFile = root;

     	try {
     		SAXParserFactory.newInstance().newSAXParser().parse(classPathFile, new DefaultHandler() {
     			public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
     				if (!"classpathentry".equals(qName)) return;
     				
     				String kind = attrs.getValue("kind");
        			String path = null;
        			if ("output".equals(kind)) {
        				path = attrs.getValue("path");
        			} else if ("src".equals(kind)) {
        				path = attrs.getValue("output");
        			} else {
        				return;
        			}
        			if (path == null || path.length() == 0) return;
        			
        			File fpath = new File(path);
        			
        			// ignore Webapp folder.
        			File parent = fpath.getParentFile();
        			if (parent != null && parent.getName().equals("WEB-INF")) return;
        			
        			fpath = (fpath.isAbsolute()) ? fpath : new File(rootFile, path);
        			if (!fpath.exists() || !fpath.isDirectory()) return;
        			
        			try {
	        			URL url = fpath.getCanonicalFile().toURI().toURL();
	           			classpathList.add(url);
	           			
	           			Logger.logDirectMessage(Logger.DEBUG, Logger.DEFAULT_STREAM, 
	           					"Adding devloader classpath " + path, null);
        			} catch (Exception e) {
        				// never occur
        			}
     			}
     		});
    	} catch (Exception e) {
    		throw new RuntimeException(e);
    	}
    	for (int i = 0; i < urls.length; i++) classpathList.add(urls[i]);
	    
    	return (URL[])classpathList.toArray(new URL[classpathList.size()]);
    }
}
