/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import org.seasar.framework.container.Expression;
import org.seasar.framework.container.impl.ComponentNameExpression;
import org.seasar.framework.container.impl.LiteralExpression;
import org.seasar.framework.container.ognl.OgnlExpression;
import org.seasar.framework.xml.TagHandler;
import org.seasar.framework.xml.TagHandlerContext;
import org.xml.sax.Locator;

public class AbstractTagHandler
extends TagHandler {
    private static final long serialVersionUID = 1L;

    protected Expression createExpression(TagHandlerContext context, String body) {
        Locator locator = context.getLocator();
        String expr = body.trim();
        String source = locator.getSystemId();
        int lineNumber = locator.getLineNumber();
        if ("null".equals(expr)) {
            return new LiteralExpression(source, lineNumber, expr, null);
        }
        if ("true".equals(expr)) {
            return new LiteralExpression(source, lineNumber, expr, Boolean.TRUE);
        }
        if ("false".equals(expr)) {
            return new LiteralExpression(source, lineNumber, expr, Boolean.FALSE);
        }
        if (AbstractTagHandler.isComponentName(expr)) {
            return new ComponentNameExpression(locator.getSystemId(), locator.getLineNumber(), expr);
        }
        return new OgnlExpression(locator.getSystemId(), locator.getLineNumber(), expr);
    }

    protected static boolean isComponentName(String expr) {
        if (!Character.isJavaIdentifierStart(expr.charAt(0))) {
            return false;
        }
        for (int i = 1; i < expr.length(); ++i) {
            if (Character.isJavaIdentifierPart(expr.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

