/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.impl;

import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.Expression;
import org.seasar.framework.container.MetaDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.util.MetaDefSupport;

public class ArgDefImpl
implements ArgDef {
    private Object value;
    private S2Container container;
    private Expression expression;
    private ComponentDef childComponentDef;
    private MetaDefSupport metaDefSupport = new MetaDefSupport();

    public ArgDefImpl() {
    }

    public ArgDefImpl(Object value) {
        this.setValue(value);
    }

    public final Object getValue() {
        if (this.expression != null) {
            return this.expression.evaluate(this.container, null);
        }
        if (this.childComponentDef != null) {
            return this.childComponentDef.getComponent();
        }
        return this.value;
    }

    public final void setValue(Object value) {
        this.value = value;
    }

    public boolean isValueGettable() {
        return this.value != null || this.childComponentDef != null || this.expression != null;
    }

    public final S2Container getContainer() {
        return this.container;
    }

    public final void setContainer(S2Container container) {
        this.container = container;
        if (this.childComponentDef != null) {
            this.childComponentDef.setContainer(container);
        }
        this.metaDefSupport.setContainer(container);
    }

    public final Expression getExpression() {
        return this.expression;
    }

    public final void setExpression(Expression expression) {
        this.expression = expression;
    }

    public final void setChildComponentDef(ComponentDef componentDef) {
        if (this.container != null) {
            componentDef.setContainer(this.container);
        }
        this.childComponentDef = componentDef;
    }

    public void addMetaDef(MetaDef metaDef) {
        this.metaDefSupport.addMetaDef(metaDef);
    }

    public MetaDef getMetaDef(int index) {
        return this.metaDefSupport.getMetaDef(index);
    }

    public MetaDef getMetaDef(String name) {
        return this.metaDefSupport.getMetaDef(name);
    }

    public MetaDef[] getMetaDefs(String name) {
        return this.metaDefSupport.getMetaDefs(name);
    }

    public int getMetaDefSize() {
        return this.metaDefSupport.getMetaDefSize();
    }
}

