/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.seasar.framework.util.FileInputStreamUtil;
import org.seasar.framework.util.FileUtil;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.JarFileUtil;

public class ResourceTraversal {
    protected ResourceTraversal() {
    }

    public static void forEach(File rootDir, ResourceHandler handler) {
        ResourceTraversal.forEach(rootDir, null, handler);
    }

    public static void forEach(File rootDir, String baseDirectory, ResourceHandler handler) {
        File baseDir = ResourceTraversal.getBaseDir(rootDir, baseDirectory);
        if (baseDir.exists()) {
            ResourceTraversal.traverseFileSystem(rootDir, baseDir, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forEach(JarFile jarFile, ResourceHandler handler) {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry entry = enumeration.nextElement();
            if (entry.isDirectory()) continue;
            String entryName = entry.getName().replace('\\', '/');
            InputStream is = JarFileUtil.getInputStream(jarFile, entry);
            try {
                handler.processResource(entryName, is);
            }
            finally {
                InputStreamUtil.close(is);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traverseFileSystem(File rootDir, File baseDir, ResourceHandler handler) {
        File[] files = baseDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                ResourceTraversal.traverseFileSystem(rootDir, file, handler);
                continue;
            }
            int pos = FileUtil.getCanonicalPath(rootDir).length();
            String filePath = FileUtil.getCanonicalPath(file);
            String resourcePath = filePath.substring(pos + 1).replace('\\', '/');
            FileInputStream is = FileInputStreamUtil.create(file);
            try {
                handler.processResource(resourcePath, is);
                continue;
            }
            finally {
                InputStreamUtil.close(is);
            }
        }
    }

    private static File getBaseDir(File rootDir, String baseDirectory) {
        File baseDir = rootDir;
        if (baseDirectory != null) {
            String[] names = baseDirectory.split("/");
            for (int i = 0; i < names.length; ++i) {
                baseDir = new File(baseDir, names[i]);
            }
        }
        return baseDir;
    }

    public static interface ResourceHandler {
        public void processResource(String var1, InputStream var2);
    }
}

