/*
 * Decompiled with CFR 0.152.
 */
package winstone.auth;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Node;
import winstone.Logger;
import winstone.Mapping;
import winstone.WebAppConfiguration;
import winstone.auth.BaseAuthenticationHandler;

public class SecurityConstraint {
    final String ELEM_DISPLAY_NAME = "display-name";
    final String ELEM_WEB_RESOURCES = "web-resource-collection";
    final String ELEM_WEB_RESOURCE_NAME = "web-resource-name";
    final String ELEM_URL_PATTERN = "url-pattern";
    final String ELEM_HTTP_METHOD = "http-method";
    final String ELEM_AUTH_CONSTRAINT = "auth-constraint";
    final String ELEM_ROLE_NAME = "role-name";
    final String ELEM_USER_DATA_CONSTRAINT = "user-data-constraint";
    final String ELEM_TRANSPORT_GUARANTEE = "transport-guarantee";
    final String GUARANTEE_NONE = "NONE";
    private String displayName;
    private String[] methodSets;
    private Mapping[] urlPatterns;
    private String[] rolesAllowed;
    private boolean needsSSL = false;

    public SecurityConstraint(Node elm, Set rolesAllowed, int counter) {
        HashSet<Mapping> localUrlPatternList = new HashSet<Mapping>();
        HashSet<String> localMethodSetList = new HashSet<String>();
        HashSet<String> localRolesAllowed = new HashSet<String>();
        for (int i = 0; i < elm.getChildNodes().getLength(); ++i) {
            Node child = elm.getChildNodes().item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equals("display-name")) {
                this.displayName = WebAppConfiguration.getTextFromNode(child);
                continue;
            }
            if (child.getNodeName().equals("web-resource-collection")) {
                String methodSet = null;
                for (int k = 0; k < child.getChildNodes().getLength(); ++k) {
                    Node resourceChild = child.getChildNodes().item(k);
                    if (resourceChild.getNodeType() != 1) continue;
                    String resourceChildNodeName = resourceChild.getNodeName();
                    if (resourceChildNodeName.equals("url-pattern")) {
                        localUrlPatternList.add(Mapping.createFromURL("Security", WebAppConfiguration.getTextFromNode(resourceChild)));
                        continue;
                    }
                    if (!resourceChildNodeName.equals("http-method")) continue;
                    methodSet = (methodSet == null ? "." : methodSet) + WebAppConfiguration.getTextFromNode(resourceChild) + ".";
                }
                localMethodSetList.add(methodSet == null ? ".ALL." : methodSet);
                continue;
            }
            if (child.getNodeName().equals("auth-constraint")) {
                for (int k = 0; k < child.getChildNodes().getLength(); ++k) {
                    Node roleChild = child.getChildNodes().item(k);
                    if (roleChild.getNodeType() != 1 || !roleChild.getNodeName().equals("role-name")) continue;
                    String roleName = WebAppConfiguration.getTextFromNode(roleChild);
                    if (roleName.equals("*")) {
                        localRolesAllowed.addAll(rolesAllowed);
                        continue;
                    }
                    localRolesAllowed.add(roleName);
                }
                continue;
            }
            if (!child.getNodeName().equals("user-data-constraint")) continue;
            for (int k = 0; k < child.getChildNodes().getLength(); ++k) {
                Node roleChild = child.getChildNodes().item(k);
                if (roleChild.getNodeType() != 1 || !roleChild.getNodeName().equals("transport-guarantee")) continue;
                this.needsSSL = !WebAppConfiguration.getTextFromNode(roleChild).equalsIgnoreCase("NONE");
            }
        }
        this.urlPatterns = localUrlPatternList.toArray(new Mapping[0]);
        this.methodSets = localMethodSetList.toArray(new String[0]);
        this.rolesAllowed = localRolesAllowed.toArray(new String[0]);
        if (this.displayName == null) {
            this.displayName = BaseAuthenticationHandler.AUTH_RESOURCES.getString("SecurityConstraint.DefaultName", "" + counter);
        }
    }

    public boolean isAllowed(HttpServletRequest request) {
        for (int n = 0; n < this.rolesAllowed.length; ++n) {
            if (!request.isUserInRole(this.rolesAllowed[n])) continue;
            Logger.log(Logger.FULL_DEBUG, BaseAuthenticationHandler.AUTH_RESOURCES, "SecurityConstraint.Passed", new String[]{this.displayName, this.rolesAllowed[n]});
            return true;
        }
        Logger.log(Logger.FULL_DEBUG, BaseAuthenticationHandler.AUTH_RESOURCES, "SecurityConstraint.Failed", this.displayName);
        return false;
    }

    public boolean isApplicable(String url, String method) {
        for (int n = 0; n < this.urlPatterns.length; ++n) {
            if (!this.urlPatterns[n].match(url, null, null) || !this.methodCheck(method, this.methodSets[n])) continue;
            return true;
        }
        return false;
    }

    private boolean methodCheck(String protocol, String methodSet) {
        return methodSet.equals(".ALL.") || methodSet.indexOf("." + protocol.toUpperCase() + ".") != -1;
    }

    public boolean needsSSL() {
        return this.needsSSL;
    }

    public String getName() {
        return this.displayName;
    }
}

