/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.unit.impl;

import java.util.List;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.log.Logger;
import org.seasar.framework.unit.ConfigFileIncluder;
import org.seasar.framework.unit.TestContext;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

public class ConfigFileIncluderImpl
implements ConfigFileIncluder {
    protected static final Logger logger = Logger.getLogger(ConfigFileIncluderImpl.class);
    protected S2Container container;
    protected final List<String> configFiles = CollectionsUtil.newArrayList();

    @Binding(bindingType=BindingType.MUST)
    public void setContainer(S2Container container) {
        this.container = container;
    }

    public void addConfigFile(String configFile) {
        this.configFiles.add(configFile);
    }

    public void include(TestContext testContext) {
        String dirPath = testContext.getTestClassPackagePath();
        for (String configFile : this.configFiles) {
            if (ResourceUtil.isExist((String)configFile)) {
                this.include(testContext, configFile);
                continue;
            }
            String path = dirPath + "/" + configFile;
            if (!ResourceUtil.isExist((String)path)) continue;
            this.include(testContext, path);
        }
    }

    protected void include(TestContext testContext, String path) {
        if (logger.isDebugEnabled()) {
            logger.log("DSSR0101", new Object[]{path});
        }
        S2ContainerFactory.include((S2Container)this.container, (String)path);
    }
}

