/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.impl;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.framework.util.StatementUtil;

public class ConfigurableStatementFactory
implements StatementFactory {
    protected StatementFactory statementFactory;
    protected Integer fetchSize;
    protected Integer maxRows;
    protected Integer queryTimeout;

    public ConfigurableStatementFactory(StatementFactory statementFactory) {
        if (statementFactory == null) {
            throw new NullPointerException("statementFactory");
        }
        this.statementFactory = statementFactory;
    }

    public PreparedStatement createPreparedStatement(Connection con, String sql) {
        PreparedStatement ps = this.statementFactory.createPreparedStatement(con, sql);
        this.configurePreparedStatement(ps);
        return ps;
    }

    public CallableStatement createCallableStatement(Connection con, String sql) {
        CallableStatement cs = this.statementFactory.createCallableStatement(con, sql);
        this.configurePreparedStatement(cs);
        return cs;
    }

    protected void configurePreparedStatement(PreparedStatement ps) {
        if (this.fetchSize != null) {
            StatementUtil.setFetchSize((Statement)ps, (int)this.fetchSize);
        }
        if (this.maxRows != null) {
            StatementUtil.setMaxRows((Statement)ps, (int)this.maxRows);
        }
        if (this.queryTimeout != null) {
            StatementUtil.setQueryTimeout((Statement)ps, (int)this.queryTimeout);
        }
    }

    public void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setMaxRows(Integer maxRows) {
        this.maxRows = maxRows;
    }

    public void setQueryTimeout(Integer queryTimeout) {
        this.queryTimeout = queryTimeout;
    }
}

