/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.framework.util.DecimalFormatUtil;
import org.seasar.framework.util.StringUtil;

public final class ShortConversionUtil {
    private ShortConversionUtil() {
    }

    public static Short toShort(Object o) {
        return ShortConversionUtil.toShort(o, null);
    }

    public static Short toShort(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Short) {
            return (Short)o;
        }
        if (o instanceof Number) {
            return new Short(((Number)o).shortValue());
        }
        if (o instanceof String) {
            return ShortConversionUtil.toShort((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new Short(new SimpleDateFormat(pattern).format(o));
            }
            return new Short((short)((Date)o).getTime());
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? new Short(1) : new Short(0);
        }
        return ShortConversionUtil.toShort(o.toString());
    }

    private static Short toShort(String s) {
        if (StringUtil.isEmpty(s)) {
            return null;
        }
        return new Short(DecimalFormatUtil.normalize(s));
    }

    public static short toPrimitiveShort(Object o) {
        return ShortConversionUtil.toPrimitiveShort(o, null);
    }

    public static short toPrimitiveShort(Object o, String pattern) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        if (o instanceof String) {
            return ShortConversionUtil.toPrimitiveShort((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return Short.parseShort(new SimpleDateFormat(pattern).format(o));
            }
            return (short)((Date)o).getTime();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? (short)1 : 0;
        }
        return ShortConversionUtil.toPrimitiveShort(o.toString());
    }

    private static short toPrimitiveShort(String s) {
        return Short.parseShort(DecimalFormatUtil.normalize(s));
    }
}

