/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.log.Logger;

public class S2ContainerFilter
implements Filter {
    public static final String INVALIDATE_SESSION = "Seasar2-invalidateSession";
    private static final Logger logger = Logger.getLogger(S2ContainerFilter.class);

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        S2Container container = SingletonS2ContainerFactory.getContainer();
        ExternalContext externalContext = container.getExternalContext();
        if (externalContext == null) {
            throw new EmptyRuntimeException("externalContext");
        }
        externalContext.setRequest(request);
        externalContext.setResponse(response);
        try {
            chain.doFilter(request, response);
            Object var7_6 = null;
            externalContext.setRequest(null);
            externalContext.setResponse(null);
            this.invalidateSession(request);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            externalContext.setRequest(null);
            externalContext.setResponse(null);
            this.invalidateSession(request);
            throw throwable;
        }
    }

    protected void invalidateSession(ServletRequest request) {
        HttpSession session;
        Object invalidateSession = request.getAttribute(INVALIDATE_SESSION);
        if (Boolean.TRUE.equals(invalidateSession) && (session = ((HttpServletRequest)request).getSession(false)) != null) {
            String id = session.getId();
            session.invalidate();
            if (logger.isDebugEnabled()) {
                logger.log("DSSR0117", new Object[]{id});
            }
        }
    }
}

