/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.beans.PropertyEditor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessException;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyBatchUpdateException;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.AbstractPropertyBindingResult;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingErrorProcessor;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DefaultBindingErrorProcessor;
import org.springframework.validation.DirectFieldBindingResult;
import org.springframework.validation.MessageCodesResolver;

public class DataBinder
implements PropertyEditorRegistry,
TypeConverter {
    public static final String DEFAULT_OBJECT_NAME = "target";
    protected static final Log logger = LogFactory.getLog((Class)DataBinder.class);
    private final Object target;
    private final String objectName;
    private AbstractPropertyBindingResult bindingResult;
    private SimpleTypeConverter typeConverter;
    private BindException bindException;
    private boolean ignoreUnknownFields = true;
    private boolean ignoreInvalidFields = false;
    private String[] allowedFields;
    private String[] disallowedFields;
    private String[] requiredFields;
    private BindingErrorProcessor bindingErrorProcessor = new DefaultBindingErrorProcessor();

    public DataBinder(Object target) {
        this(target, DEFAULT_OBJECT_NAME);
    }

    public DataBinder(Object target, String objectName) {
        this.target = target;
        this.objectName = objectName;
    }

    public Object getTarget() {
        return this.target;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void initBeanPropertyAccess() {
        Assert.isNull(this.bindingResult, "DataBinder is already initialized - call initBeanPropertyAccess before any other configuration methods");
        this.bindingResult = new BeanPropertyBindingResult(this.getTarget(), this.getObjectName());
    }

    public void initDirectFieldAccess() {
        Assert.isNull(this.bindingResult, "DataBinder is already initialized - call initDirectFieldAccess before any other configuration methods");
        this.bindingResult = new DirectFieldBindingResult(this.getTarget(), this.getObjectName());
    }

    protected AbstractPropertyBindingResult getInternalBindingResult() {
        if (this.bindingResult == null) {
            this.initBeanPropertyAccess();
        }
        return this.bindingResult;
    }

    protected ConfigurablePropertyAccessor getPropertyAccessor() {
        return this.getInternalBindingResult().getPropertyAccessor();
    }

    protected SimpleTypeConverter getSimpleTypeConverter() {
        if (this.typeConverter == null) {
            this.typeConverter = new SimpleTypeConverter();
        }
        return this.typeConverter;
    }

    protected PropertyEditorRegistry getPropertyEditorRegistry() {
        if (this.getTarget() != null) {
            return this.getInternalBindingResult().getPropertyAccessor();
        }
        return this.getSimpleTypeConverter();
    }

    protected TypeConverter getTypeConverter() {
        if (this.getTarget() != null) {
            return this.getInternalBindingResult().getPropertyAccessor();
        }
        return this.getSimpleTypeConverter();
    }

    public BindingResult getBindingResult() {
        return this.getInternalBindingResult();
    }

    public BindException getErrors() {
        if (this.bindException == null) {
            this.bindException = new BindException(this.getBindingResult());
        }
        return this.bindException;
    }

    public void setIgnoreUnknownFields(boolean ignoreUnknownFields) {
        this.ignoreUnknownFields = ignoreUnknownFields;
    }

    public boolean isIgnoreUnknownFields() {
        return this.ignoreUnknownFields;
    }

    public void setIgnoreInvalidFields(boolean ignoreInvalidFields) {
        this.ignoreInvalidFields = ignoreInvalidFields;
    }

    public boolean isIgnoreInvalidFields() {
        return this.ignoreInvalidFields;
    }

    public void setAllowedFields(String[] allowedFields) {
        this.allowedFields = PropertyAccessorUtils.canonicalPropertyNames(allowedFields);
    }

    public String[] getAllowedFields() {
        return this.allowedFields;
    }

    public void setDisallowedFields(String[] disallowedFields) {
        this.disallowedFields = PropertyAccessorUtils.canonicalPropertyNames(disallowedFields);
    }

    public String[] getDisallowedFields() {
        return this.disallowedFields;
    }

    public void setRequiredFields(String[] requiredFields) {
        this.requiredFields = PropertyAccessorUtils.canonicalPropertyNames(requiredFields);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DataBinder requires binding of required fields [" + StringUtils.arrayToCommaDelimitedString(requiredFields) + "]"));
        }
    }

    public String[] getRequiredFields() {
        return this.requiredFields;
    }

    public void setExtractOldValueForEditor(boolean extractOldValueForEditor) {
        this.getPropertyAccessor().setExtractOldValueForEditor(extractOldValueForEditor);
    }

    public void setMessageCodesResolver(MessageCodesResolver messageCodesResolver) {
        this.getInternalBindingResult().setMessageCodesResolver(messageCodesResolver);
    }

    public void setBindingErrorProcessor(BindingErrorProcessor bindingErrorProcessor) {
        this.bindingErrorProcessor = bindingErrorProcessor;
    }

    public BindingErrorProcessor getBindingErrorProcessor() {
        return this.bindingErrorProcessor;
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        this.getPropertyEditorRegistry().registerCustomEditor(requiredType, propertyEditor);
    }

    public void registerCustomEditor(Class requiredType, String field, PropertyEditor propertyEditor) {
        this.getPropertyEditorRegistry().registerCustomEditor(requiredType, field, propertyEditor);
    }

    public PropertyEditor findCustomEditor(Class requiredType, String propertyPath) {
        return this.getPropertyEditorRegistry().findCustomEditor(requiredType, propertyPath);
    }

    public Object convertIfNecessary(Object value, Class requiredType) throws TypeMismatchException {
        return this.getTypeConverter().convertIfNecessary(value, requiredType);
    }

    public Object convertIfNecessary(Object value, Class requiredType, MethodParameter methodParam) throws TypeMismatchException {
        return this.getTypeConverter().convertIfNecessary(value, requiredType, methodParam);
    }

    public void bind(PropertyValues pvs) {
        MutablePropertyValues mpvs = pvs instanceof MutablePropertyValues ? (MutablePropertyValues)pvs : new MutablePropertyValues(pvs);
        this.doBind(mpvs);
    }

    protected void doBind(MutablePropertyValues mpvs) {
        this.checkAllowedFields(mpvs);
        this.checkRequiredFields(mpvs);
        this.applyPropertyValues(mpvs);
    }

    protected void checkAllowedFields(MutablePropertyValues mpvs) {
        PropertyValue[] pvs = mpvs.getPropertyValues();
        for (int i = 0; i < pvs.length; ++i) {
            PropertyValue pv = pvs[i];
            String field = PropertyAccessorUtils.canonicalPropertyName(pv.getName());
            if (this.isAllowed(field)) continue;
            mpvs.removePropertyValue(pv);
            this.getBindingResult().recordSuppressedField(field);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Field [" + field + "] has been removed from PropertyValues " + "and will not be bound, because it has not been found in the list of allowed fields"));
        }
    }

    protected boolean isAllowed(String field) {
        Object[] allowed = this.getAllowedFields();
        Object[] disallowed = this.getDisallowedFields();
        return !(!ObjectUtils.isEmpty(allowed) && !PatternMatchUtils.simpleMatch((String[])allowed, field) || !ObjectUtils.isEmpty(disallowed) && PatternMatchUtils.simpleMatch((String[])disallowed, field));
    }

    protected void checkRequiredFields(MutablePropertyValues mpvs) {
        Object[] requiredFields = this.getRequiredFields();
        if (!ObjectUtils.isEmpty(requiredFields)) {
            int i;
            HashMap<String, PropertyValue> propertyValues = new HashMap<String, PropertyValue>();
            PropertyValue[] pvs = mpvs.getPropertyValues();
            for (i = 0; i < pvs.length; ++i) {
                PropertyValue pv = pvs[i];
                String canonicalName = PropertyAccessorUtils.canonicalPropertyName(pv.getName());
                propertyValues.put(canonicalName, pv);
            }
            for (i = 0; i < requiredFields.length; ++i) {
                Object field = requiredFields[i];
                PropertyValue pv = (PropertyValue)propertyValues.get(field);
                if (pv != null && pv.getValue() != null && (!(pv.getValue() instanceof String) || StringUtils.hasText((String)pv.getValue()))) continue;
                this.getBindingErrorProcessor().processMissingFieldError((String)field, this.getInternalBindingResult());
                if (pv == null) continue;
                mpvs.removePropertyValue(pv);
                propertyValues.remove(field);
            }
        }
    }

    protected void applyPropertyValues(MutablePropertyValues mpvs) {
        try {
            this.getPropertyAccessor().setPropertyValues(mpvs, this.isIgnoreUnknownFields(), this.isIgnoreInvalidFields());
        }
        catch (PropertyBatchUpdateException ex) {
            PropertyAccessException[] exs = ex.getPropertyAccessExceptions();
            for (int i = 0; i < exs.length; ++i) {
                this.getBindingErrorProcessor().processPropertyAccessException(exs[i], this.getInternalBindingResult());
            }
        }
    }

    public Map close() throws BindException {
        if (this.getBindingResult().hasErrors()) {
            throw new BindException(this.getBindingResult());
        }
        return this.getBindingResult().getModel();
    }
}

