/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.query;

import java.util.Map;
import org.seasar.extension.jdbc.DbmsDialect;
import org.seasar.extension.jdbc.IterationCallback;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.Select;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.handler.BeanIterationResultSetHandler;
import org.seasar.extension.jdbc.handler.BeanListResultSetHandler;
import org.seasar.extension.jdbc.handler.BeanResultSetHandler;
import org.seasar.extension.jdbc.handler.MapIterationResultSetHandler;
import org.seasar.extension.jdbc.handler.MapListResultSetHandler;
import org.seasar.extension.jdbc.handler.MapResultSetHandler;
import org.seasar.extension.jdbc.handler.ObjectIterationResultSetHandler;
import org.seasar.extension.jdbc.handler.ObjectListResultSetHandler;
import org.seasar.extension.jdbc.handler.ObjectResultSetHandler;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.query.AbstractSelect;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.framework.convention.PersistenceConvention;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSqlSelect<T, S extends Select<T, S>>
extends AbstractSelect<T, S>
implements Select<T, S> {
    public AbstractSqlSelect(JdbcManagerImplementor jdbcManager, Class<T> baseClass) {
        super(jdbcManager, baseClass);
    }

    @Override
    protected ResultSetHandler createResultListResultSetHandler() {
        ValueType valueType;
        DbmsDialect dialect = this.jdbcManager.getDialect();
        PersistenceConvention persistenceConvention = this.jdbcManager.getPersistenceConvention();
        boolean simple = ValueTypes.isSimpleType((Class)this.baseClass);
        ValueType valueType2 = valueType = simple ? this.getValueType(this.baseClass, this.resultLob, this.resultTemporalType) : null;
        if (simple) {
            return new ObjectListResultSetHandler(valueType, this.limit);
        }
        if (Map.class.isAssignableFrom(this.baseClass)) {
            return new MapListResultSetHandler(this.baseClass, dialect, persistenceConvention, this.executedSql, this.limit);
        }
        return new BeanListResultSetHandler(this.baseClass, dialect, this.executedSql, this.limit);
    }

    @Override
    protected ResultSetHandler createSingleResultResultSetHandler() {
        DbmsDialect dialect = this.jdbcManager.getDialect();
        PersistenceConvention persistenceConvention = this.jdbcManager.getPersistenceConvention();
        if (ValueTypes.isSimpleType((Class)this.baseClass)) {
            ValueType valueType = this.getValueType(this.baseClass, this.resultLob, this.resultTemporalType);
            return new ObjectResultSetHandler(valueType, this.executedSql);
        }
        if (Map.class.isAssignableFrom(this.baseClass)) {
            return new MapResultSetHandler(this.baseClass, dialect, persistenceConvention, this.executedSql);
        }
        return new BeanResultSetHandler(this.baseClass, dialect, this.executedSql);
    }

    @Override
    protected ResultSetHandler createIterateResultSetHandler(IterationCallback<T, ?> callback) {
        ValueType valueType;
        DbmsDialect dialect = this.jdbcManager.getDialect();
        PersistenceConvention persistenceConvention = this.jdbcManager.getPersistenceConvention();
        boolean simple = ValueTypes.isSimpleType((Class)this.baseClass);
        ValueType valueType2 = valueType = simple ? this.getValueType(this.baseClass, this.resultLob, this.resultTemporalType) : null;
        if (simple) {
            return new ObjectIterationResultSetHandler(valueType, this.limit, callback);
        }
        if (Map.class.isAssignableFrom(this.baseClass)) {
            return new MapIterationResultSetHandler(this.baseClass, dialect, persistenceConvention, this.executedSql, this.limit, callback);
        }
        return new BeanIterationResultSetHandler(this.baseClass, dialect, this.executedSql, this.limit, callback);
    }
}

