/*
 * Decompiled with CFR 0.152.
 */
package winstone.jndi;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.NamingManager;
import winstone.Logger;
import winstone.jndi.ContainerJNDIManager;
import winstone.jndi.WinstoneBindingEnumeration;
import winstone.jndi.WinstoneNameEnumeration;
import winstone.jndi.WinstoneNameParser;

public class WinstoneContext
implements Context {
    static final String PREFIX = "java:";
    static final String FIRST_CHILD = "comp";
    static final String BODGED_PREFIX = "java:comp";
    private Hashtable environment = new Hashtable();
    private Hashtable bindings;
    private static final NameParser nameParser = new WinstoneNameParser();
    private WinstoneContext parent;
    private String myAbsoluteName;
    private Object contextLock;

    public WinstoneContext(Map sourceEnvironment, WinstoneContext parent, String absoluteName, Object contextLock) throws NamingException {
        ArrayList sourceKeys = new ArrayList(sourceEnvironment.keySet());
        Iterator i = sourceKeys.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            this.addToEnvironment(key, sourceEnvironment.get(key));
        }
        this.parent = parent;
        this.myAbsoluteName = absoluteName;
        this.contextLock = contextLock;
        this.bindings = new Hashtable();
        Logger.log(Logger.FULL_DEBUG, ContainerJNDIManager.JNDI_RESOURCES, "WinstoneContext.Initialised", this.myAbsoluteName);
    }

    protected WinstoneContext(Map sourceEnvironment, WinstoneContext parent, String absoluteName, Object contextLock, Hashtable bindings) throws NamingException {
        ArrayList sourceKeys = new ArrayList(sourceEnvironment.keySet());
        Iterator i = sourceKeys.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            this.addToEnvironment(key, sourceEnvironment.get(key));
        }
        this.parent = parent;
        this.myAbsoluteName = absoluteName;
        this.contextLock = contextLock;
        this.bindings = bindings;
        Logger.log(Logger.FULL_DEBUG, ContainerJNDIManager.JNDI_RESOURCES, "WinstoneContext.Copied", this.myAbsoluteName);
    }

    public void close() throws NamingException {
    }

    public Hashtable getEnvironment() throws NamingException {
        return new Hashtable(this.environment);
    }

    public Object removeFromEnvironment(String property) throws NamingException {
        return this.environment.remove(property);
    }

    public Object addToEnvironment(String property, Object value) throws NamingException {
        return this.environment.put(property, value);
    }

    protected Name validateName(Name name) throws NamingException {
        if (name.isEmpty()) {
            return name;
        }
        if (name.get(0).equals(BODGED_PREFIX)) {
            Name newName = name.getSuffix(1).add(0, FIRST_CHILD).add(0, PREFIX);
            return this.validateName(newName);
        }
        if (name.get(0).equals(PREFIX)) {
            String stringName = name.toString();
            if (stringName.equals(this.myAbsoluteName)) {
                return nameParser.parse("");
            }
            if (stringName.startsWith(this.myAbsoluteName)) {
                return nameParser.parse(stringName.substring(this.myAbsoluteName.length() + 1));
            }
            if (this.parent != null) {
                return null;
            }
            throw new NameNotFoundException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.NameNotFound", name.toString()));
        }
        if (name instanceof CompositeName) {
            return nameParser.parse(name.toString());
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(Name name) throws NamingException {
        Name searchName = this.validateName(name);
        if (searchName == null) {
            return this.parent.lookup(name);
        }
        if (searchName.isEmpty()) {
            return new WinstoneContext(this.environment, this.parent, this.myAbsoluteName, this.contextLock, this.bindings);
        }
        String thisName = searchName.get(0);
        Object object = this.contextLock;
        synchronized (object) {
            Object object2;
            Object thisValue = this.bindings.get(thisName);
            if (searchName.size() == 1) {
                if (thisValue == null) {
                    throw new NameNotFoundException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.NameNotFound", name.toString()));
                }
                try {
                    return NamingManager.getObjectInstance(thisValue, new CompositeName().add(thisName), this, this.environment);
                }
                catch (Exception e) {
                    NamingException ne = new NamingException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.FailedToGetInstance"));
                    ne.setRootCause(e);
                    throw ne;
                }
            }
            if (thisValue == null) {
                throw new NameNotFoundException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.NameNotFound", thisName.toString()));
            }
            if (!(thisValue instanceof Context)) {
                throw new NotContextException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.NotContext", new String[]{thisName.toString(), thisValue.getClass().getName()}));
            }
            try {
                object2 = ((Context)thisValue).lookup(searchName.getSuffix(1));
            }
            catch (Throwable throwable) {
                ((Context)thisValue).close();
                throw throwable;
            }
            ((Context)thisValue).close();
            return object2;
        }
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        Logger.log(Logger.WARNING, ContainerJNDIManager.JNDI_RESOURCES, "WinstoneContext.LinkRefUnsupported");
        return this.lookup(name);
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(new CompositeName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingEnumeration list(Name name) throws NamingException {
        Name searchName = this.validateName(name);
        if (searchName == null) {
            return this.parent.list(name);
        }
        if (searchName.isEmpty()) {
            WinstoneNameEnumeration e = null;
            Object object = this.contextLock;
            synchronized (object) {
                e = new WinstoneNameEnumeration(this.bindings);
            }
            return e;
        }
        Object ctx = this.lookup(searchName);
        if (ctx instanceof Context) {
            try {
                NamingEnumeration<NameClassPair> namingEnumeration = ((Context)ctx).list(new CompositeName(""));
                return namingEnumeration;
            }
            finally {
                ((Context)ctx).close();
            }
        }
        if (ctx == null) {
            throw new NameNotFoundException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.NameNotFound", searchName.toString()));
        }
        throw new NotContextException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.NotContext", new String[]{searchName.toString(), ctx.getClass().getName()}));
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingEnumeration listBindings(Name name) throws NamingException {
        Name searchName = this.validateName(name);
        if (searchName == null) {
            return this.parent.list(name);
        }
        if (searchName.isEmpty()) {
            WinstoneBindingEnumeration e = null;
            Object object = this.contextLock;
            synchronized (object) {
                e = new WinstoneBindingEnumeration(this.bindings, this.environment, this);
            }
            return e;
        }
        Object ctx = this.lookup(searchName);
        if (ctx instanceof Context) {
            try {
                NamingEnumeration<Binding> namingEnumeration = ((Context)ctx).listBindings(new CompositeName(""));
                return namingEnumeration;
            }
            finally {
                ((Context)ctx).close();
            }
        }
        if (ctx == null) {
            throw new NameNotFoundException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.NameNotFound", searchName.toString()));
        }
        throw new NotContextException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.NotContext", new String[]{searchName.toString(), ctx.getClass().getName()}));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        Object obj = this.lookup(name);
        if (obj instanceof Context) {
            ((Context)obj).close();
        }
        return nameParser;
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(new CompositeName(name));
    }

    public String getNameInNamespace() throws NamingException {
        return this.myAbsoluteName;
    }

    public void bind(String name, Object value) throws NamingException {
        this.bind(new CompositeName(name), value);
    }

    public void bind(Name name, Object value) throws NamingException {
        this.bind(name, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bind(Name name, Object value, boolean allowOverwrites) throws NamingException {
        Name bindName = this.validateName(name);
        if (bindName == null) {
            this.parent.bind(name, value, allowOverwrites);
        } else {
            if (bindName.isEmpty()) {
                throw new NamingException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.AlreadyExists", name.toString()));
            }
            if (bindName.size() > 1) {
                Object ctx = this.lookup(bindName.get(0));
                if (!(ctx instanceof Context)) {
                    throw new NotContextException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.NotContext", new String[]{bindName.get(0), ctx.getClass().getName()}));
                }
                if (ctx == null) {
                    throw new NameNotFoundException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.NameNotFound", bindName.get(0)));
                }
                try {
                    if (allowOverwrites) {
                        ((Context)ctx).rebind(bindName.getSuffix(1), value);
                    }
                    ((Context)ctx).bind(bindName.getSuffix(1), value);
                }
                finally {
                    ((Context)ctx).close();
                }
            } else {
                if (!allowOverwrites && this.bindings.get(name.get(0)) != null) {
                    throw new NamingException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.AlreadyExists", name.toString()));
                }
                value = NamingManager.getStateToBind(value, new CompositeName().add(bindName.get(0)), this, this.environment);
                Object object = this.contextLock;
                synchronized (object) {
                    this.bindings.put(bindName.get(0), value);
                }
            }
        }
    }

    public void rebind(String name, Object value) throws NamingException {
        this.rebind(new CompositeName(name), value);
    }

    public void rebind(Name name, Object value) throws NamingException {
        this.bind(name, value, true);
    }

    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(Name name) throws NamingException {
        Name unbindName = this.validateName(name);
        if (unbindName == null) {
            this.parent.unbind(name);
        } else {
            if (unbindName.isEmpty()) {
                throw new NamingException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.CantUnbindEmptyName"));
            }
            if (unbindName.size() > 1) {
                Object ctx = this.lookup(unbindName.get(0));
                if (!(ctx instanceof Context)) {
                    throw new NotContextException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.NotContext", new String[]{unbindName.get(0), ctx.getClass().getName()}));
                }
                if (ctx == null) {
                    throw new NameNotFoundException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.NameNotFound", unbindName.get(0)));
                }
                try {
                    ((Context)ctx).unbind(unbindName.getSuffix(1));
                }
                finally {
                    ((Context)ctx).close();
                }
            }
            if (this.bindings.get(name.get(0)) == null) {
                throw new NamingException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.NameNotFound", name.toString()));
            }
            Object object = this.contextLock;
            synchronized (object) {
                this.bindings.remove(unbindName.get(0));
            }
        }
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        throw new OperationNotSupportedException("rename not supported in Winstone java:/ context");
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.rename(new CompositeName(oldName), new CompositeName(newName));
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new CompositeName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context createSubcontext(Name name) throws NamingException {
        Name childName = this.validateName(name);
        if (childName == null) {
            return this.parent.createSubcontext(name);
        }
        if (childName.isEmpty()) {
            throw new NamingException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.AlreadyExists", name.toString()));
        }
        if (childName.size() > 1) {
            Object ctx = this.lookup(childName.get(0));
            if (!(ctx instanceof Context)) {
                throw new NotContextException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.NotContext", new String[]{childName.get(0), ctx.getClass().getName()}));
            }
            if (ctx == null) {
                throw new NameNotFoundException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.NameNotFound", childName.get(0)));
            }
            try {
                ((Context)ctx).createSubcontext(childName.getSuffix(1));
            }
            finally {
                ((Context)ctx).close();
            }
        }
        WinstoneContext childContext = null;
        Object object = this.contextLock;
        synchronized (object) {
            if (this.bindings.get(childName.get(0)) != null) {
                throw new NamingException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.AlreadyExists", childName.get(0)));
            }
            childContext = new WinstoneContext(this.environment, this, this.myAbsoluteName + "/" + childName.get(0), new Boolean(true));
            this.bindings.put(childName.get(0), childContext);
        }
        return childContext;
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new CompositeName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void destroySubcontext(Name name) throws NamingException {
        Name childName = this.validateName(name);
        if (childName == null) {
            this.parent.destroySubcontext(name);
            return;
        }
        if (childName.isEmpty()) {
            if (name.isEmpty()) throw new NamingException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.CantDestroyEmptyName"));
            this.parent.destroySubcontext(name.getSuffix(name.size() - 2));
            return;
        }
        if (childName.size() > 1) {
            Object ctx = this.lookup(childName.get(0));
            if (!(ctx instanceof Context)) {
                throw new NotContextException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.NotContext", new String[]{childName.get(0), ctx.getClass().getName()}));
            }
            if (ctx == null) {
                throw new NameNotFoundException(ContainerJNDIManager.JNDI_RESOURCES.getString("WinstoneContext.NameNotFound", childName.get(0)));
            }
            try {
                ((Context)ctx).destroySubcontext(childName.getSuffix(1));
                return;
            }
            finally {
                ((Context)ctx).close();
            }
        }
        Object object = this.contextLock;
        synchronized (object) {
            Context childContext = (Context)this.lookup(childName.get(0));
            childContext.close();
            this.bindings.remove(childName.get(0));
            return;
        }
    }

    public String composeName(String name1, String name2) throws NamingException {
        Name name = this.composeName(new CompositeName(name1), new CompositeName(name2));
        return name == null ? null : name.toString();
    }

    public Name composeName(Name name1, Name name2) throws NamingException {
        throw new OperationNotSupportedException("composeName not supported in Winstone java:/ namespace");
    }
}

