/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.mock.portlet;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortalContext;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletSession;
import javax.portlet.WindowState;
import org.seasar.framework.mock.portlet.MockPortletRequest;
import org.seasar.framework.mock.portlet.MockPortletSessionImpl;
import org.seasar.framework.util.EnumerationAdapter;

public class MockPortletRequestImpl
implements MockPortletRequest {
    private PortletContext portletContext;
    private String authType;
    private MockPortletSessionImpl session;
    private String scheme = "http";
    private String serverName = "localhost";
    private int serverPort = 80;
    private Map properties = new HashMap();
    private Map attributes = new HashMap();
    private Map parameters = new HashMap();
    private List locales = new ArrayList();
    private List contentTypes = new ArrayList();

    public MockPortletRequestImpl(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    public boolean isWindowStateAllowed(WindowState arg0) {
        throw new UnsupportedOperationException();
    }

    public boolean isPortletModeAllowed(PortletMode arg0) {
        throw new UnsupportedOperationException();
    }

    public PortletMode getPortletMode() {
        throw new UnsupportedOperationException();
    }

    public WindowState getWindowState() {
        throw new UnsupportedOperationException();
    }

    public PortletPreferences getPreferences() {
        throw new UnsupportedOperationException();
    }

    public PortletSession getPortletSession() {
        return this.getPortletSession(true);
    }

    public PortletSession getPortletSession(boolean create) {
        if (this.session != null) {
            return this.session;
        }
        if (create) {
            this.session = new MockPortletSessionImpl(this.portletContext);
        }
        if (this.session != null) {
            this.session.access();
        }
        return this.session;
    }

    public String getProperty(String name) {
        if (this.properties.get(name) instanceof String) {
            return (String)this.properties.get(name);
        }
        if (this.properties.get(name) instanceof String[]) {
            String[] values = (String[])this.parameters.get(name);
            if (values == null || values.length == 0) {
                return null;
            }
            return values[0];
        }
        return null;
    }

    public Enumeration getProperties(String name) {
        if (this.properties.get(name) instanceof String[]) {
            String[] values = (String[])this.parameters.get(name);
            ArrayList<String> array = new ArrayList<String>();
            for (int i = 0; i < values.length; ++i) {
                array.add(values[i]);
            }
            return new EnumerationAdapter(array.iterator());
        }
        return null;
    }

    public Enumeration getPropertyNames() {
        return new EnumerationAdapter(this.properties.keySet().iterator());
    }

    public PortalContext getPortalContext() {
        throw new UnsupportedOperationException();
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getContextPath() {
        return this.portletContext.getPortletContextName();
    }

    public String getRemoteUser() {
        return System.getProperty("user.name");
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException();
    }

    public boolean isUserInRole(String arg0) {
        throw new UnsupportedOperationException();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return new EnumerationAdapter(this.attributes.keySet().iterator());
    }

    public String getParameter(String name) {
        String[] values = (String[])this.parameters.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Enumeration getParameterNames() {
        return new EnumerationAdapter(this.parameters.keySet().iterator());
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameters.get(name);
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public boolean isSecure() {
        return false;
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getRequestedSessionId() {
        if (this.session != null) {
            return this.session.getId();
        }
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        if (this.session != null) {
            return this.session.isValid();
        }
        return false;
    }

    public String getResponseContentType() {
        return (String)this.contentTypes.get(0);
    }

    public Enumeration getResponseContentTypes() {
        return new EnumerationAdapter(this.contentTypes.iterator());
    }

    public Locale getLocale() {
        return (Locale)this.locales.get(0);
    }

    public Enumeration getLocales() {
        return new EnumerationAdapter(this.locales.iterator());
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void addProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public void addParameter(String name, String value) {
        String[] values = this.getParameterValues(name);
        if (values == null) {
            this.setParameter(name, value);
        } else {
            String[] newArray = new String[values.length + 1];
            System.arraycopy(values, 0, newArray, 0, values.length);
            newArray[newArray.length - 1] = value;
            this.parameters.put(name, newArray);
        }
    }

    public void addParameter(String name, String[] values) {
        if (values == null) {
            this.setParameter(name, (String)null);
            return;
        }
        String[] vals = this.getParameterValues(name);
        if (vals == null) {
            this.setParameter(name, values);
        } else {
            String[] newArray = new String[vals.length + values.length];
            System.arraycopy(vals, 0, newArray, 0, vals.length);
            System.arraycopy(values, 0, newArray, vals.length, values.length);
            this.parameters.put(name, newArray);
        }
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, new String[]{value});
    }

    public void setParameter(String name, String[] values) {
        this.parameters.put(name, values);
    }

    public void addResponseContentType(String contentType) {
        this.contentTypes.add(contentType);
    }

    public void removeResponseContentType(String contentType) {
        this.contentTypes.remove(contentType);
    }

    public void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    public void removeLocale(Locale locale) {
        this.locales.remove(locale);
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }
}

