/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.ExternalContextComponentDefRegister;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.container.util.SmartDeployUtil;
import org.seasar.framework.env.Env;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.exception.JarDuplicatedException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.DisposableUtil;
import org.seasar.framework.util.InputStreamUtil;

public class SingletonS2ContainerFactory {
    private static final Logger logger = Logger.getLogger(SingletonS2ContainerFactory.class);
    private static String configPath = "app.dicon";
    private static ExternalContext externalContext;
    private static ExternalContextComponentDefRegister externalContextComponentDefRegister;
    private static S2Container container;

    private SingletonS2ContainerFactory() {
    }

    public static String getConfigPath() {
        return configPath;
    }

    public static void setConfigPath(String path) {
        configPath = path;
    }

    public static ExternalContext getExternalContext() {
        return externalContext;
    }

    public static void setExternalContext(ExternalContext extCtx) {
        externalContext = extCtx;
    }

    public static ExternalContextComponentDefRegister getExternalContextComponentDefRegister() {
        return externalContextComponentDefRegister;
    }

    public static void setExternalContextComponentDefRegister(ExternalContextComponentDefRegister extCtxComponentDefRegister) {
        externalContextComponentDefRegister = extCtxComponentDefRegister;
    }

    public static void init() {
        if (container != null) {
            return;
        }
        SingletonS2ContainerFactory.checkVersions();
        container = S2ContainerFactory.create(configPath);
        if (container.getExternalContext() == null) {
            if (externalContext != null) {
                container.setExternalContext(externalContext);
            }
        } else if (container.getExternalContext().getApplication() == null && externalContext != null) {
            container.getExternalContext().setApplication(externalContext.getApplication());
        }
        if (container.getExternalContextComponentDefRegister() == null && externalContextComponentDefRegister != null) {
            container.setExternalContextComponentDefRegister(externalContextComponentDefRegister);
        }
        container.init();
        logger.info("Running on [ENV]" + Env.getValue() + ", [DEPLOY MODE]" + SmartDeployUtil.getDeployMode(container));
    }

    public static void destroy() {
        if (container == null) {
            return;
        }
        container.destroy();
        container = null;
        DisposableUtil.dispose();
    }

    public static S2Container getContainer() {
        if (container == null) {
            throw new EmptyRuntimeException("S2Container");
        }
        return container;
    }

    public static void setContainer(S2Container c) {
        container = c;
    }

    public static boolean hasContainer() {
        return container != null;
    }

    private static void checkVersions() {
        SingletonS2ContainerFactory.checkVersion("s2-framework");
        SingletonS2ContainerFactory.checkVersion("s2-extension");
        SingletonS2ContainerFactory.checkVersion("s2-tiger");
    }

    private static void checkVersion(String artifactId) {
        List versions = SingletonS2ContainerFactory.getVersions(artifactId);
        if (versions.isEmpty()) {
            return;
        }
        if (versions.size() > 1) {
            throw new JarDuplicatedException(artifactId, versions);
        }
        logger.log("ISSR0009", new Object[]{artifactId, versions.get(0)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getVersions(String artifactId) {
        ArrayList<String> versions = new ArrayList<String>();
        try {
            String name = "META-INF/maven/org.seasar.container/" + artifactId + "/pom.properties";
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(name);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                InputStream is = url.openStream();
                try {
                    Properties props = new Properties();
                    props.load(is);
                    versions.add(props.getProperty("version"));
                }
                finally {
                    InputStreamUtil.close(is);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return versions;
    }
}

