class Mode_SemiAuto;
class Mode_Burst;
class Mode_FullAuto;
class CfgPatches
{
	class JSDF_W_SMG_MP5
	{
		units[] = {};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {"CAweapons"};
	};
};
class CfgRecoils
{
	JSDF_MP5_recoil[]			= {0.02, 0.02, 0.01,   0.05, 0.002, -0.01,   0.04, -0.01,0.005,  0.05, 0, 0};
	JSDF_MP5_recoilProne[]			= {0.02, 0.01, 0.01,   0.05, 0.002, -0.01,   0.04, -0.01,0.005,  0.05, 0, 0};
};
class CfgWeapons
{
	class JSDF_MP;
	class JSDF_HK_MP5_A5 			: JSDF_MP
	{
		scope 				= 2;

		fireLightDuration 		= 0.000;
		fireLightIntensity 		= 0.000;

		dexterity 			= 1.75;

		displayName 			= H&K MP5 A5;
		picture				="\CA\weapons\data\equip\W_HKM5_A5_CA.paa";
		UiPicture			="\CA\weapons\data\Ico\i_regular_CA.paa";
		model				="\JSDF_W\MP_MP5\JSDF_HKM5_A5";
		handAnim[] 			= {"OFP2_ManSkeleton", "\Ca\weapons\data\Anim\HKMP5.rtm"};

		magazines[]			={30Rnd_9x19_MP5SD,30Rnd_9x19_MP5};

		drySound[]			={\ca\Weapons\Data\Sound\M16_cock_v1,db-70,1};
		reloadMagazineSound[]		={\ca\Weapons\Data\Sound\MP5_reload,0.05, 1, 25};
		distanceZoomMin			=50;
		distanceZoomMax			=50;

		value 				= NEVER_DESTROY;

		initSpeed			=400;
		modes[] 			= {Single, Burst, FullAuto};
		class Single 			: Mode_SemiAuto
		{
			sound[]			={\JSDF_W\MP_MP5\MP5.wss, 0.8, 1, 700};
			reloadTime		=0.075;
			recoil			=JSDF_MP5_recoil;
			recoilProne		=JSDF_MP5_recoilProne;

			dispersion		=0.002;
			minRange=2;minRangeProbab=0.10;
			midRange=40;midRangeProbab=0.7;
			maxRange=150;maxRangeProbab=0.05;
		};
		class Burst			: Mode_Burst
		{
			sound[]			={\JSDF_W\MP_MP5\MP5.wss, 0.8, 1, 700};
			soundContinuous		=0;
			soundBurst 		= false;
			reloadTime		=0.075;
			ffCount			=1;
			recoil			=JSDF_MP5_recoil;
			recoilProne		=JSDF_MP5_recoilProne;

			dispersion		=0.002;
			minRange=2;minRangeProbab=0.10;
			midRange=30;midRangeProbab=0.7;
			maxRange=60;maxRangeProbab=0.05;
		};
		class FullAuto 			: Mode_FullAuto
		{
			sound[]			={\JSDF_W\MP_MP5\MP5.wss, 0.8, 1, 700};
			soundContinuous		=0;
			reloadTime		=0.075;
			ffCount			=1;
			recoil			=JSDF_MP5_recoil;
			recoilProne		=JSDF_MP5_recoilProne;
			aiRateOfFire		=0.001;
			dispersion		=0.002;
			minRange=2;minRangeProbab=0.20;
			midRange=20;midRangeProbab=0.7;
			maxRange=40;maxRangeProbab=0.05;
		};
		class Library {libTextDesc = $STR_LIB_MP5;};
	};
	class JSDF_HK_MP5_SD 			: JSDF_HK_MP5_A5
	{
		displayName 			= H&K MP5 SD;
		picture				="\CA\weapons\data\equip\W_HKM5_SD6_CA.paa";
		UiPicture			="\CA\weapons\data\Ico\i_regular_CA.paa";
		model				="\JSDF_W\MP_MP5\JSDF_HKM5_SD6";

		dexterity 			= 1.8;
		fireLightDuration 		= 0.05;
		fireLightIntensity 		= 0.012;

		class Single 			: Single
		{
			sound[]			={\ca\Weapons\Data\Sound\MP5_silenced_SS,db-40,1};
		};
		class Burst			: Burst
		{
			sound[]			={\ca\Weapons\Data\Sound\MP5_silenced_SS,db-40,1};
		};
		class FullAuto 			: FullAuto
		{
			sound[]			={\ca\Weapons\Data\Sound\MP5_silenced_SS,db-40,1};
		};
		class Library {libTextDesc = $STR_LIB_MP5A5;};
	};
};