class Mode_SemiAuto;
class Mode_Burst;
class Mode_FullAuto;
class CfgPatches
{
	class JSDF_W_AAG_35mm_KD
	{
		units[] = {};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {"CAweapons"};
	};
};
class CfgAmmo
{
	class JSDF_Sh_AP ;
	class JSDF_Sh_HE ;
	class JSDF_Sh_35x228_APDS		: JSDF_Sh_AP
	{
		airLock				=  1;
		irLock				=  1;
		hit				=149;
		indirectHit			=  5;
		indirectHitRange		=  0.1;
		caliber 			=  5.8;
		typicalSpeed			=950;
		airFriction			=  -0.0005;
		model				= \JSDF_W\G_35mm_KD\sh_35mm_APDS;
	};
	class JSDF_Sh_35x228_APDS_T		: JSDF_Sh_35x228_APDS	{};
	class JSDF_Sh_35x228_TP_T		: JSDF_Sh_35x228_APDS	{hit=10;};	//PMD064
	class JSDF_Sh_35x228_HEI		: JSDF_Sh_HE				//PMD040
	{
		hit				=79;
		indirectHit			=10;
		indirectHitRange		= 1;
		explosive			= 1.5;
		model				= \JSDF_W\G_35mm_KD\sh_35mm_HEI;
		soundHit[]			={\JSDF_W\G_35mm_KD\_exp.wss, 0.5, 1, 1000};
	};
	class JSDF_Sh_35x228_HEI_T		: JSDF_Sh_35x228_HEI		{};
	class JSDF_Sh_35x228_SAPHEI_T		: JSDF_Sh_35x228_HEI		{};
};
class CfgMagazines
{
	class VehicleMagazine ;
	class JSDF_AAG_KD_HE			: VehicleMagazine
	{
		scope				= 2;
		displayName			= HEI;
		ammo				= JSDF_Sh_35x228_HEI;
		count				= 0;
		initSpeed			= 1175;
	};
	class JSDF_AAG_KD_HE_T			: JSDF_AAG_KD_HE
	{
		displayName			= HEI-T;
		ammo				= JSDF_Sh_35x228_HEI_T;
	};
	class JSDF_AAG_KD_AP_T			: VehicleMagazine
	{
		scope				= 2;
		displayName			= APDS-T;
		ammo				= JSDF_Sh_35x228_APDS_T;
		count				= 0;
		initSpeed			= 1385;
	};
	class JSDF_AAG_KDA_HE			: JSDF_AAG_KD_HE	{count=2;};
	class JSDF_AAG_KDA_HE_T			: JSDF_AAG_KD_HE_T	{count=2;};
	class JSDF_AAG_KDA_AP_T			: JSDF_AAG_KD_AP_T	{count=2;};
	class JSDF_AAG_KDE_HE			: JSDF_AAG_KD_HE	{count=17;};
	class JSDF_AAG_KDE_HE_T			: JSDF_AAG_KD_HE_T	{count=17;};
	class JSDF_AAG_KDE_AP_T			: JSDF_AAG_KD_AP_T	{count=17;};
};
class CfgWeapons
{
	class JSDF_AAG;
	class JSDF_AAG_KD			: JSDF_AAG
	{
		scope				= 1;
		displayName			= 35mm;
		canLock				= 2;
		autoFire			= 1;
		sound[]				={\JSDF_W\G_35mm_KD\35mmKD.wss, 135.0, 1, 1900};
		soundBurst			= false;
		reloadTime			= 1.0;
		reloadSound[]			={};

		aiRateOfFire			= 0.001;
		minRange=1	;minRangeProbab=0.10;
		midRange=3000	;midRangeProbab=0.7;
		maxRange=12000	;maxRangeProbab=0.1;
	};

	class JSDF_AAG_KDA			: JSDF_AAG_KD		//t87AW
	{
		displayName			= 35mm KDA;
		reloadTime			= 0.0545;
		magazineReloadTime		= 0.0545;
		ffCount				= 20;
		burst				= 20;
		autoReload			= 1;
	};
	class JSDF_AAG_KDA_HE			: JSDF_AAG_KDA	{displayName= HEI-T;	magazines[]={JSDF_AAG_KDA_HE_T,JSDF_AAG_KDA_HE};	maxLeadSpeed= 800;	};
	class JSDF_AAG_KDA_AP			: JSDF_AAG_KDA	{displayName= APDS-T;	magazines[]={JSDF_AAG_KDA_AP_T};			maxLeadSpeed= 800;	};

	class JSDF_AAG_KDB			: JSDF_AAG_KD		//L90(GDF-001)
	{
		displayName			= 35mm KDB;
		reloadTime			= 0.0545;
		magazineReloadTime		= 0.0545;
		ffCount				= 20;
	};
	class JSDF_AAG_KDC			: JSDF_AAG_KD		//GDM-A
	{
		displayName			= 35mm KDC;
		reloadTime			= 0.0545;
		magazineReloadTime		= 0.0545;
		ffCount				= 20;
		useAsBinocular			= true;
		primary				= 0;
	};

	class JSDF_AAG_KDE			: JSDF_AAG_KD		//t89FV
	{
		magazineReloadTime		= 10.5;
		autoReload			= 0;
		backgroundReload		= 0;
		type				= 4096;
		modes[]				={KDE_SemiAuto,KDE_3Burst,KDE_FullAuto};
		class KDE_SemiAuto 		: Mode_SemiAuto
		{
			displayName		="SemiAuto";
			sound[]			={\JSDF_W\G_35mm_KD\35mmKD.wss, 135.0, 1, 1900};
			reloadTime		= 0.3;
			minRange=   2;minRangeProbab=0.10;
			midRange=3000;midRangeProbab=0.7;
			maxRange=4000;maxRangeProbab=0.04;
		};
		class KDE_3Burst 		: Mode_Burst
		{
			displayName		="Burst";
			sound[]			={\JSDF_W\G_35mm_KD\35mmKD.wss, 135.0, 1, 1900};
			reloadTime		= 0.3;
			dispersion		=0.0015;
			minRange=  2;minRangeProbab=0.10;
			midRange=1500;midRangeProbab=0.7;
			maxRange=2800;maxRangeProbab=0.04;
		};
		class KDE_FullAuto 		: Mode_FullAuto
		{
			displayName		="FullAuto";
			sound[]			={\JSDF_W\G_35mm_KD\35mmKD.wss, 135.0, 1, 1900};
			reloadTime		= 0.3;
			ffCount			= 17;
			dispersion		= 0.0015;
			minRange=   2;minRangeProbab=0.10;
			midRange= 250;midRangeProbab=0.7;
			maxRange=1500;maxRangeProbab=0.05;
		};
	};
	class JSDF_AAG_KDE_HE			: JSDF_AAG_KDE
	{
		magazines[]			={JSDF_AAG_KDE_HE_T,JSDF_AAG_KDE_HE};
		modes[]				={KDE_SemiAuto_HE,KDE_3Burst_HE,KDE_FullAuto_HE};
		class KDE_SemiAuto_HE 		:KDE_SemiAuto	{displayName="HEI-T SemiAuto";	backgroundReload= 0;};
		class KDE_3Burst_HE		:KDE_3Burst	{displayName="HEI-T Burst";	};
		class KDE_FullAuto_HE		:KDE_FullAuto	{displayName="HEI-T FullAuto";	};
	};
	class JSDF_AAG_KDE_AP			: JSDF_AAG_KDE
	{
		magazines[]			={JSDF_AAG_KDE_AP_T};
		modes[]				={KDE_SemiAuto_AP,KDE_3Burst_AP,KDE_FullAuto_AP};
		class KDE_SemiAuto_AP 		:KDE_SemiAuto	{displayName="APDS-T SemiAuto";	};
		class KDE_3Burst_AP		:KDE_3Burst	{displayName="APDS-T Burst";	};
		class KDE_FullAuto_AP		:KDE_FullAuto	{displayName="APDS-T FullAuto";	};
	};
};