#define TEast		0
#define TWest		1
#define TGuerrila	2
#define TCivilian	3
#define TSideUnknown	4
#define TEnemy		5
#define TFriendly	6
#define TLogic		7

#define true	1
#define false	0

#define CanSeeAll 31

#define private		0
#define protected	1
#define public		2

class CfgModels
{
	class Default{};
	class Ship: Default{};
	class BigSHip: Ship {};
	class DDG173: BigShip{};
	class DD122: BigShip{};
	class SS573: Bigship{};
	class newport: BigShip{};
};

class CfgPatches
{
        class JMSDF
	{
		units[] = {"xBOHDDG173","SS573"};
		weapons[] = {"xBOHRIM67SM2ER","xBOHRIM67SM2ER_29"};
	};
};

class CfgAmmo
{

	class Default	{};
	class xBOHRIM67SM2ER : Default
	{
		hit=400;indirectHit=200;indirectHitRange=10;//4.2kg
		airLock=1;irLock=1;laserLock=1;manualControl=1;
	
		model=		"\JMSDF\w\SM\RIM67SM2ER.p3d";
		proxyshape=	"\JMSDF\w\SM\RIM67SM2ER_proxy.p3d";
		
		audibleFire=32;
		visibleFire=32;
		visibleFireTime=60;
		cost=20000;
		
		simulation="shotMissile";
		simulationStep=0.050000;
		maxSpeed=400;
		initTime=0.5;
		thrustTime=60.0;
		thrust=250;
		sideAirFriction=0.05;
		maneuvrability=25;
		
		maxControlRange=10000;
		minRange=1500;	minRangeProbab=0.95;
		midRange=3000;	midRangeProbab=0.75;
		maxRange=9000;	maxRangeProbab=0.05;
	};
	class xBOHRIM66SM2MR : xBOHRIM67SM2ER
	{
		model=		"\JMSDF\w\SM\RIM66SM2MR.p3d";
		proxyshape=	"\JMSDF\w\SM\RIM66SM2MR_proxy.p3d";
	};
	
	class xBOHRIM156ASM2ER : xBOHRIM67SM2ER
	{
		model=		"\JMSDF\w\SM\RIM156ASM2ER.p3d";
		proxyshape=	"\JMSDF\w\SM\RIM156ASM2ER_proxy.p3d";
	};
	class xBOHRIM156ASM2ERNoMk72 : xBOHRIM156ASM2ER
	{
		model=		"\JMSDF\w\SM\RIM156ASM2ERNoMk72.p3d";
		proxyshape=	"\JMSDF\w\SM\RIM156ASM2ERNoMk72_proxy.p3d";
	};
	
	class xBOHRIM161SM3 : xBOHRIM67SM2ER
	{
		model=		"\JMSDF\w\SM\RIM161SM3.p3d";
		proxyshape=	"\JMSDF\w\SM\RIM161SM3_proxy.p3d";
	};
	class xBOHRIM161SM3NoMk72 : xBOHRIM161SM3
	{
		model=		"\JMSDF\w\SM\RIM161SM3NoMk72.p3d";
		proxyshape=	"\JMSDF\w\SM\RIM161SM3NoMk72_proxy.p3d";
	};
	class AT3:Default{};
//	class CarlGustav:AT3{};
//	class AA:CarlGustav{};
//	class xBOHSM2ammo:AA
//	{
//		thrust=150;
//		maneuvrability=5000;
//	};
	class Shell:Default{};
	class Shell73:Shell{};
	class xBOHShell76RFG:Shell73
	{
		airLock=1;
//		simulation="shotBullet";
	};
	class Hellfire : AT3 {};
	class xBOHProximity_fuseModel: Hellfire
	{
		proxyShape = ZUNI;
		hit=0;indirectHit=0;indirectHitRange=0.0001;
		minRange=50;minRangeProbab=0.20;
		midRange=250;midRangeProbab=0.20;
		maxRange=1000;maxRangeProbab=0.05;
		maxSpeed=1000;
		simulation=shotRocket;
		simulationStep=0.05;
		cost=20;
		soundHit[]={"\Explosions\expl1",db80,1};
		model= "\JMSDF\w\explosion_tgt.p3d";
		irLock=false;
		laserLock=false;
		maneuvrability=0.0;
		maxControlRange=0;
		initTime=10;
		thrustTime=3.5;
		thrust=500;
	};
};

class CfgWeapons
{
	class Default{};
	class LAWLauncher:Default{};
	class CarlGustavLauncher:LAWLauncher{};
	class AT3Launcher:CarlGustavLauncher{};
	class xBOHRIM67SM2ER:AT3Launcher
	{
		scopeWeapon=2;
		scopeMagazine=2;
		weaponType=65536;
		magazineType=0;
		magazines[]={"xBOHRIM67SM2ER","xBOHRIM67SM2ER_29"};
		cost=200000;

		displayName="RIM-67 SM2-ER";
		displayNameMagazine="RIM-67 SM2-ER";
		shortNameMagazine="SM2";

		ammo="xBOHRIM67SM2ER";
		count=1;
		reloadTime=0.1;
//		reloadSound[]={"Weapons\at_load",db-50,1};
		aiRateOfFire=10.0;
		aiRateOfFireDistance=1000;
		initSpeed=500;
		primary=10;
		canLock=2;
		autoReload=1;

	};
	class xBOHRIM67SM2ER_29:xBOHRIM67SM2ER
	{
		count=29;
	};

	class xBOHRIM66SM2MR:xBOHRIM67SM2ER
	{
		magazines[]={"xBOHRIM66SM2MR"};
		displayName="RIM-66 SM2-MR";
		displayNameMagazine="RIM-66 SM2-MR";
		shortNameMagazine="SM2";
		ammo="xBOHRIM66SM2MR";
	};
	//RIM-156A SM2-ER
	class xBOHRIM156ASM2ER:xBOHRIM67SM2ER
	{
		magazines[]={"xBOHRIM156ASM2ER_29"};
		displayName="RIM-156A SM2-ER";
		displayNameMagazine="RIM-156A SM2-ER";
		shortNameMagazine="SM2";
		ammo="xBOHRIM156ASM2ER";
	};
	class xBOHRIM156ASM2ER_29:xBOHRIM156ASM2ER
	{
		count=29;
	};
	
	//RIM-161 SM3
	class xBOHRIM161SM3:xBOHRIM67SM2ER
	{
		magazines[]={"xBOHRIM161SM3_29"};
		displayName="RIM-161 SM3";
		displayNameMagazine="RIM-161 SM3";
		shortNameMagazine="SM3";
		ammo="xBOHRIM161SM3";
	};
	class xBOHRIM161SM3_29:xBOHRIM161SM3
	{
		count=29;
	};
	
	class Gun73:Default{};
	class xBOH76RFG:Gun73
	{
		DisplayName="76mm Rapid Fire Gun";
		magazines[]={"xBOH76RFGmag"};
		reloadTime=0.75;
		aiRateOfFire=0.75;
		autoFire=1;
		initSpeed=919.5;
		maxLeadSpeed=1500;
		aiRateOfFireDistance=16000;
	}
	class Shell73 : Default{};
	class xBOH76RFGmag : Shell73
	{
		DisplayName="76mm Rapid Fire Gun";
		ammo="xBOHShell76RFG";
		reloadTime=0.75;
		aiRateOfFire=0.75;
		count=120;
		autoFire=1;
		initSpeed=919.5;
		maxLeadSpeed=1500;
		aiRateOfFireDistance=3500;
	};
	class BOHaim7 : Default {};
	class xBOHrim7 : BOHaim7
	{
		maxLeadSpeed=1500;
		DisplayName="RIM-7M Sea Sparrow";
		count=8;
	};
};

class CfgVehicles
{
	class All {};
	class AllVehicles: All {};
	class Ship: AllVehicles {};
	class BigShip:Ship {};
	class CarrierW:BigShip {};

	class JMSDFBaseShip:CarrierW
	{
		model="\JMSDF\newport.p3d";
		scope=2;
		side=2;
		vehicleClass="JMSDF";
		unitInfoType="unitinfoAIRPLANE"
		hasGunner=0;
		hasCommander=0;
		driverCanSee=31;
		nameSound="ship";
		weapons[]={};
		magazines[]={};
		type=1;
		threat[]={1,1,0.3};
		canFloat=1;
		transportMaxMagazines=1000;
		transportMaxWeapons=500;
		armorHull=1;
		armorTurret=0.6;
		armorGun=100;
		armorEngine=0.8;
		armorTracks=0.9;
		steerAheadSimul=1.00000;
		steerAheadPlan=1.20000;
		predictTurnSimul=1.00000;
		predictTurnPlan=1.20000;
		viewGunnerInExternal = true;
		forceHideGunner = true;
		accuracy=0.9;
		fuelCapacity=700000;
		displayName="BaseShip";
	};

	class xBOHDDG173: JMSDFBaseShip
	{
		displayName="DDG-173";
		irScanRange=8000;
		armor=6000;
		cost=10000000;
		maxSpeed=56;
		model="\JMSDF\DDG173\DDG173.p3d";
	};
	

	class Static : All {};
	class Building : Static {};
	class Strategic: Building{}; 
	class shed1: Strategic{};
	class xBOHDDG173o: shed1
	{
		side=2;
		vehicleClass="JMSDF";
		displayName="DDG-173o";
		nameSound="ship";
		armor=6000;
		model="\JMSDF\DDG173\DDG173.p3d";
		reversed=1;
   		autocenter=0;
		mapSize=65;
		destrType="DestructBuilding";
		scope=1;
		animated=1;
	};
	
	//SS573 YUSHIO Class
	class xBOHSS573: xBOHDDG173
	{
		displayName="SS-573";
		irScanRange=3000;
		armor=2000;
		maxSpeed=38;
		model="\JMSDF\SS573\SS573.p3d";
		hasCommander=1;
		hasgunner=1;
		hasDriver=1;
		
		driverAction="ManActT55Driver";
		driverInAction="ManActT55Driver";
		gunnerAction="ManActT55Gunner";
		gunnerInAction="ManActT55Gunner";
		commanderAction="ManActPBRDriver";
		commanderInAction="ManActPBRDriver";
		cargoAction[]={"ManActT55Driver","ManActT55Gunner"};
		transportSoldier=2;

		class Animations
		{
			class depthF
			{
				type="rotation";
				animPeriod=60;
				selection="depthF";
				axis="depthFAX";
				angle0=0;
				angle1=3.141592654 / 2 * -1;
			};
			class depthB
			{
				type="rotation";
				animPeriod=60;
				selection="depthB";
				axis="depthBAX";
				angle0=0;
				angle1=3.141592654 / 2 * -1;
			};
			class ea
			{
				type="rotation";
				animPeriod=0.0001;
				selection="ea";
				axis="eaAX";
				angle0=0;
				angle1=-1;
			};
			class prop
			{
				type="rotation";
				animPeriod=100000;
				selection="prop";
				axis="propAX";
				angle0=1000000000000 * 3.141592654;
				angle1=0;
			};
		};
		class UserActions
		{
			class Dive
			{
				displayName="Dive";
				position="act";
				radius=10;
				condition="this animationphase ""depthF"" < 1";
				statement="[this] exec {\JMSDF\SS573\dive.sqs}";
			};
			class Stop
			{
				displayName="Dive / Blow Stop";
				position="act";
				radius=10;
				condition="this animationphase ""ea"" > 0.5";
				statement="this animate [""ea"",0]";
			};
			class Blow
			{
				displayName="Blow";
				position="act";
				radius=10;
				condition="this animationphase ""depthF"" > 0.01";
				statement="[this] exec {\JMSDF\SS573\blow.sqs}";
			};
		};
		class EventHandlers
		{
			init = "[_this select 0] exec ""\jmsdf\ss573\ss573init.sqs""";
		};
	};
	
	//DD122 HATSUYUKI Class
	class xBOHDD122: xBOHDDG173
	{
		displayName="DD-122";
		nameSound="ship";
		armor=5000;
		model="\JMSDF\DD122\DD122.p3d";
	};
	class xBOHDD122Base: xBOHDDG173
	{
		displayName="DD-122Base";
		nameSound="ship";
		armor=5000;
		model="\JMSDF\DD122\DD122Base.p3d";
	};
	class xBOHDD122o: xBOHDDG173o
	{
		displayName="DD-122o";
		nameSound="ship";
		armor=5000;
		model="\JMSDF\DD122\DD122.p3d";
	};
	class xBOHDD122o1: xBOHDD122o
	{
		displayName="DD-122o1";
		nameSound="ship";
		armor=5000;
		model="\JMSDF\DD122\DD122_1.p3d";
	};
	class xBOHDD122o2: xBOHDD122o1
	{
		displayName="DD-122o2";
		model="\JMSDF\DD122\DD122_2.p3d";
	};
	class xBOHDD122o3: xBOHDD122o1
	{
		displayName="DD-122o3";
		model="\JMSDF\DD122\DD122_3.p3d";
	};

	class Land:AllVehicles{};
	class LandVehicle:Land{};
	class Tank:LandVehicle{};
	class APC:Tank{};
	class M113:APC{};
	class xBOHMk41VSL29:M113
	{
		side=2;
		vehicleClass="JMSDF";
		displayName="Mk.41 VSL 29 cell";
		model="\JMSDF\w\mk41vls\Mk41VSL29.p3d";
		weapons[]={"xBOHRIM67SM2ER","xBOHRIM156ASM2ER","xBOHRIM161SM3"};
		magazines[]={"xBOHRIM67SM2ER_29","xBOHRIM156ASM2ER_29","xBOHRIM161SM3_29"};
		hasDriver=0;
		hasGunner=1;
		hasCommander=0;
		type=0;
		armor=1000;
		fuelCapacity=0;

		gunnerCanSee="1+16 +4+8";
		irTarget=1;
		irScanRangeMin=1500;
		irScanRangeMax=20000;
		irScanToEyeFactor=500;

		class EventHandlers
		{
//			fired = "[_this] exec {\JMSDF\sqs\fired.sqs}";
			fired = "[_this] exec {\JMSDF\w\mk41vls\fired.sqs}; [_this] exec {\JMSDF\sqs\fireds.sqs}; [_this] exec {\JMSDF\w\SM\fire.sqs}";
		};
	};
	class ZSU:Tank{};
	class xBOHOTO76mm : ZSU
	{
		side=2;
		model="\JMSDF\w\76mm\76mm.p3d";
		vehicleClass="JMSDF";
		displayName="OTO 76mm Gun";
		Weapons[]={"xBOH76RFG"};
		Magazines[]={"xBOH76RFGmag"};
		hasDriver=0;
		hasGunner=1;
		hasCommander=0;
		fuelCapacity=0;
		transportSoldier=0;
		type=0;
		cost=10000;
		maxSpeed=1;
		irScanRangeMin=8000;
		irScanRangeMax=20000;
		irScanToEyeFactor=5;

		class Turret
		{
			gunAxis="OsaHlavne";
			turretAxis="OsaVeze";
			soundServo[]={,db-40,1.0};
			body="OtocVez";
			gun="OtocHlaven";
			gunBeg="usti hlavne";
			gunEnd="konec hlavne";
			minElev=-15;
			maxElev=85;
			minTurn=-360;
			maxTurn=360;
		};

		class Animations
		{
			class rec
			{
				type="rotation";
				animPeriod=0.1;
				selection="barrel";
				axis="osaBarrel";
				angle0=0;
				angle1=-0.005;
			};
		};

		class EventHandlers
		{
			fired = "[_this] exec {\JMSDF\w\76mm\fire.sqs}";
		};

	};
	class xBOH20mmCIWS : xBOHOTO76mm
	{
		model="\JMSDF\w\CIWS\20mmCIWS.p3d";
		displayName="20mm CIWS";
		Weapons[]={"BOHm61p_945"};
		Magazines[]={"BOHm61p_945"};
		irScanRangeMin=1000;
		irScanRangeMax=5000;

		class ReloadAnimations
		{
			class xBOH20mmCIWS_anim
			{
				weapon="BOHm61p_945";
				angle0=0
				angle1="15";
				multiplier=167;
				type="rotation";
				animPeriod=1;
				selection="gatling";
				begin="usti hlavne";
				end="konec hlavne";
			};
		};

		class Animations {};
		class EventHandlers	{};

		class Turret
		{
			gunAxis="OsaHlavne";
			turretAxis="OsaVeze";
			soundServo[]={,db-40,1.0};
			body="OtocVez";
			gun="OtocHlaven";
			gunBeg="usti hlavne";
			gunEnd="konec hlavne";
			minElev=-20;
			maxElev=80;
			minTurn=-360;
			maxTurn=360;
		};
	};
	class xBOHSeaSparrowLauncher : xBOHOTO76mm
	{
		model="\JMSDF\w\RIM7\NATOSeaSparrowL.p3d";
		displayName="Sea Sparrow Launcher";
		Weapons[]={"xBOHrim7"};
		Magazines[]={"xBOHrim7","xBOHrim7"};
		irScanRangeMin=8000;
		irScanRangeMax=13000;

		class Animations {};

		class Turret
		{
			gunAxis="OsaHlavne";
			turretAxis="OsaVeze";
			soundServo[]={,db-40,1.0};
			body="OtocVez";
			gun="OtocHlaven";
			gunBeg="usti hlavne";
			gunEnd="konec hlavne";
			minElev=-10;
			maxElev=70;
			minTurn=-360;
			maxTurn=360;
		};

		class EventHandlers
		{
			fired = "[_this] exec {\JMSDF\w\RIM7\fire.sqs}";
		};
	};

	class xBOHASROCLauncher : xBOHSeaSparrowLauncher
	{
		model="\JMSDF\w\ASROC\Mark112_Launcher.p3d";
		displayName="ASROC Launcher";
		Weapons[]={"Flare"};
		Magazines[]={"Flare"};

		class EventHandlers{};
	};

	class xBOHSSMLauncher1 : xBOHSeaSparrowLauncher
	{
		model="\JMSDF\w\SSM\Mk141.p3d";
		displayName="Harpoon Launcher";
		Weapons[]={"BOHASM2_4","BOHAAM3"};
		Magazines[]={"BOHASM2_4","BOHAAM3"};

		class EventHandlers{};
	};

	class SmallShip:Ship{};
	class BoatW:SmallShip{};
	class xBOHMk48_torpedo:BoatW
	{
		vehicleClass="JMSDF";
		model="\JMSDF\w\t80tpd\Mk48.p3d";
		displayName="Mk48 Torpedo";
		Weapons[]={"BOHmk82_8"};
		Magazines[]={"BOHmk82_8"};
		side=2;
		hasgunner=0;
		armor=40;
		
		class Animations
		{
			class depthR
			{
				type="rotation";
				animPeriod=1.570795;
				selection="depthR";
				axis="depthRAX";
				angle0=0;
				angle1=-1;
			};
			class depthL
			{
				type="rotation";
				animPeriod=1.570795;
				selection="depthL";
				axis="depthLAX";
				angle0=0;
				angle1=-1;
			};
		};
	};
};