class CfgPatches
{
	class JSDF_VLA_Type90TK
	{
		units[] = {Type90TK};
		weapons[] = {};
		requiredVersion = 1.0;
//		requiredAddons[] = {"JSDF", "JSDF_W"};
	};
};
class WeaponFireGun;	// External class reference
class WeaponCloudsGun;	// External class reference
class WeaponFireMGun;	// External class reference
class WeaponCloudsMGun;	// External class reference

class CfgVehicles
{
	class Land;				// External class reference
	class LandVehicle 			: Land {};
	class Tank 				: LandVehicle {};
	class JSDF_Tank 			: Tank
	{
		class Turrets;			// External class reference
		class NewTurret;		// External class reference
		class MainTurret;		// External class reference
		class ViewOptics;		// External class reference
		class CommanderOptics;		// External class reference
		class HitPoints;		// External class reference
		class AnimationSources;		// External class reference
		class Sounds;			// External class reference
	};
	class Type90TK 				: JSDF_Tank
	{
		scope 				= 2;
		faction 			= JGSDF;
		displayName 			= "Type90 TK";
		model 				= "\JSDF_VLA\t90TK\JGSDF_Type90TK_2";
		picture 			= "\ca\tracked2\Data\UI\Picture_t34_CA.paa";
		Icon 				= "\ca\tracked2\Data\UI\Icon_t34_CA.paa";
		mapSize 			= 7;

		driverForceOptics 		= 1;
		driverAction 			= "T90_Driver";
		driverInAction 			= "T90_Driver";

		tracksSpeed 			= 2.5;
		wheelCircumference 		= 4.0;

		maxSpeed 			= 70;
		accuracy 			= 0.8;
		armor 				= 900;
		damageResistance 		= 0.005;
		cost 				= 1500000;
		
		class HitPoints : HitPoints
		{
			class HitHull	{armor = 0.85;	material = -1;	name = "telo";	visual= "telo";		passThrough 	= 1;	};
		};

//		typicalCargo[] = {"GUE_Soldier_1", "GUE_Soldier_1", "GUE_Soldier_1"};
		
		class Turrets: Turrets
		{
			class MainTurret: MainTurret
			{
				gunBeg			="maingun_muzzle";
				gunEnd			="maingun_chamber";
				memoryPointGun		="coaxgun";
				maxHorizontalRotSpeed	= 1.3;
				maxVerticalRotSpeed	= 1.04;
				gunnerAction		= Abrams_CommanderOut;
				gunnerInAction		= Abrams_Gunner;
				gunnerCompartments	="Compartment2";
    				gunnerCanSee		= 31;
				insideSoundCoef 	= 0.5;

				weapons[]		={JSDF_L44,JSDF_Type74MG_coax};
				magazines[]		=
				{
120mmTKG_JM33_APFSDS_T,		120mmTKG_JM33_APFSDS_T,		120mmTKG_JM33_APFSDS_T,		120mmTKG_JM33_APFSDS_T,
120mmTKG_JM33_APFSDS_T,		120mmTKG_JM33_APFSDS_T,		120mmTKG_JM33_APFSDS_T,		120mmTKG_JM33_APFSDS_T,
120mmTKG_JM12A1_HEAT_MP_T,	120mmTKG_JM12A1_HEAT_MP_T,	120mmTKG_JM12A1_HEAT_MP_T,	120mmTKG_JM12A1_HEAT_MP_T,
120mmTKG_JM12A1_HEAT_MP_T,	120mmTKG_JM12A1_HEAT_MP_T,	120mmTKG_JM12A1_HEAT_MP_T,	120mmTKG_JM12A1_HEAT_MP_T,
				4500Rnd_7_62x51_M13
				};
				soundServo[]		={\ca\Weapons\Data\Sound\gun_elevate,db-50,1.0};
				outGunnerMayFire	= 0;
				inGunnerMayFire		= 1;
				forceHideGunner		= 0;
				viewGunnerInExternal	= 0;
				gunnerUsesPilotView	= 1;
				gunnerForceOptics	= 0;
				gunnerOpticsModel	="\ca\Tracked\optika_tank_gunner";
				minElev=-7; maxElev=+10; initElev=0;
				class ViewOptics
				{
					initAngleX=0; minAngleX=-30; maxAngleX=+30;
					initAngleY=0; minAngleY=-100; maxAngleY=+100;
					initFov=0.166; minFov=0.025; maxFov=0.333;
				};
				class ViewGunner
				{
					initAngleX=0; minAngleX=-60; maxAngleX=+60;
					initAngleY=0; minAngleY=-100; maxAngleY=+100;
					initFov=0.42; minFov=0.22; maxFov=0.64;
				};
				class Turrets: Turrets
				{
					class CommanderOptics: CommanderOptics
					{
						gunnerCompartments	="Compartment2";
						body			="commanderViewTurret";
						gun			="commanderView";
						animationSourceBody	="commanderViewTurret";
						animationSourceGun	="commanderView";
						animationSourceHatch	="hatchCommander";

						weapons[]		= {};
						magazines[]		= {};
						outGunnerMayFire	= 0;
						inGunnerMayFire		= 1;
						forceHideGunner		= 0;
						viewGunnerInExternal	= 1;
						gunnerForceOptics	= 0;
						insideSoundCoef 	= 0.5;

						gunnerAction		= Abrams_CommanderOut;
						gunnerInAction		= Abrams_Commander;
						gunnerOpticsModel	="\ca\Tracked\optika_M1A1_commander";
						minElev= -10; maxElev= +10; initElev=0;
						minTurn= -90; maxTurn= +90; initTurn=0;
						class ViewOptics
						{
							initAngleX=0; minAngleX=-30; maxAngleX=+30;
							initAngleY=0; minAngleY=-100; maxAngleY=+100;
							initFov=0.42; minFov=0.22; maxFov=0.64;
						};
						class ViewGunner
						{
							initAngleX=0; minAngleX=-60; maxAngleX=+60;
							initAngleY=0; minAngleY=-100; maxAngleY=+100;
							initFov=0.42; minFov=0.22; maxFov=0.64;
						};
					};
				};
			};
		};
		type = 1;
		threat[] = {0.4, 0.4, 0.0};

		class AnimationSources
		{
			class mainGun_recoil
			{
				source="user";
				animPeriod 	=0.5;
				initPhase	=0.01;
			};
			class obsGun_recoil
			{
				source="reload";
				weapon="M2";
			};
			class belt_rotation
			{
				source="reload";
				weapon="M2";
			};
		};
		
		class Damage {
			tex[] = {};
			mat[] = {};
		};
	};
};
