class CfgPatches {
	class JSDF_VLA_Type74TK
{
		units[] = {Type74TK};
		weapons[] = {};
		requiredVersion = 0.7;
		requiredAddons[] = {"JSDF"};
	};
};
class WeaponFireGun;	// External class reference
class WeaponCloudsGun;	// External class reference
class WeaponFireMGun;	// External class reference
class WeaponCloudsMGun;	// External class reference


class CfgVehicles
{
	class Land;	// External class reference
	class LandVehicle 		: Land {};
	class Tank 			: LandVehicle {};
	class JSDF_Tank 		: Tank
	{
		class Turrets;			// External class reference
		class NewTurret;		// External class reference
		class MainTurret;		// External class reference
		class ViewOptics;		// External class reference
		class CommanderOptics;		// External class reference
		class HitPoints;		// External class reference
		class AnimationSources;		// External class reference
		class Sounds;			// External class reference
	};
	class Type74TK 			: JSDF_Tank
	{
		scope 			= 2;
		faction 		= JGSDF;
		displayName 		= "Type74 TK";
		model 			= "\JSDF_VLA\t74TK\JGSDF_Type74TKe_2L";
		picture 		= "\ca\tracked2\Data\UI\Picture_t34_CA.paa";
		Icon 			= "\ca\tracked2\Data\UI\Icon_t34_CA.paa";
		mapSize 		= 7;

		driverForceOptics 	= 1;
		driverAction 		= "T90_Driver";
		driverInAction 		= "T90_Driver";

		tracksSpeed 		= 2.5;
		wheelCircumference 	= 4.0;

		maxSpeed 		= 45;
		accuracy 		= 0.8;
		armor 			= 300;
		damageResistance 	= 0.01011;
		cost 			= 1500000;
		
		class HitPoints : HitPoints
		{
			class HitHull	{armor = 0.85;	material = -1;	name = "telo";	visual= "telo";		passThrough 	= 1;	};
		};

//		typicalCargo[] = {"GUE_Soldier_1", "GUE_Soldier_1", "GUE_Soldier_1"};
		
		class Turrets : Turrets
		{
			class MainTurret : MainTurret
			{
				gunBeg				="maingun_muzzle";
				gunEnd				="maingun_chamber";
				memoryPointGun			="coaxgun";
				maxHorizontalRotSpeed		= 0.8;
				maxVerticalRotSpeed		= 0.6;
				gunnerAction			= Abrams_Gunner;
				gunnerInAction			= Abrams_Gunner;
				gunnerGetInAction 		= "GetInMedium";
				gunnerGetOutAction 		= "GetOutMedium";
				memoryPointsGetInGunner 	= "pos gunner";
				memoryPointsGetInGunnerDir 	= "pos gunner dir";
				gunnerCompartments		="Compartment2";
    				gunnerCanSee			= 31;

				weapons[]		= {JSDF_L7A1,JSDF_Type74MG_coax};
				magazines[]		=
				{
105mmTKG_Type93_APFSDS_T,	105mmTKG_Type93_APFSDS_T,	105mmTKG_Type93_APFSDS_T,	105mmTKG_Type93_APFSDS_T,	105mmTKG_Type93_APFSDS_T,
105mmTKG_Type93_APFSDS_T,	105mmTKG_Type93_APFSDS_T,	105mmTKG_Type93_APFSDS_T,	105mmTKG_Type93_APFSDS_T,	105mmTKG_Type93_APFSDS_T,
105mmTKG_Type91_HEAT_MP_T,	105mmTKG_Type91_HEAT_MP_T,	105mmTKG_Type91_HEAT_MP_T,	105mmTKG_Type91_HEAT_MP_T,	105mmTKG_Type91_HEAT_MP_T,
105mmTKG_Type91_HEAT_MP_T,	105mmTKG_Type91_HEAT_MP_T,	105mmTKG_Type91_HEAT_MP_T,	105mmTKG_Type91_HEAT_MP_T,	105mmTKG_Type91_HEAT_MP_T,
				4500Rnd_7_62x51_M13
				};

				soundServo[]			={\ca\Weapons\Data\Sound\gun_elevate,db-50,1.0};
				stabilizedInAxes 		= 0;
				forceHideGunner			= 1;
				viewGunnerInExternal		= 0;
				gunnerUsesPilotView		= 1;
				gunnerForceOptics		= 0;
				gunnerOpticsModel		="\ca\Tracked\optika_tank_gunner";

				minElev=-8; maxElev=+13; initElev=0;
				class ViewOptics
				{
					initAngleX=0;	minAngleX= -30;	maxAngleX= +30;
					initAngleY=0;	minAngleY=-100;	maxAngleY=+100;
					initFov=0.166;	minFov=0.025;	maxFov=0.333;
				};

				class Turrets: Turrets
				{
					class CommanderOptics 		: CommanderOptics
					{
						primaryGunner		= 0;
						primaryObserver 	= 1;
						commanding		= 1;
						gunnerCompartments	="Compartment2";
						body			="commanderView";
						gun			="commanderView";

						minElev= -11;	maxElev= +55;	initElev=0;
						minTurn=-360;	maxTurn=+360;	initTurn=0;

						gunBeg			="obsgun_muzzle";
						gunEnd			="obsgun_chamber";
						weapons[]		= {M2};
						magazines[]		= {100Rnd_127x99_M2,100Rnd_127x99_M2,100Rnd_127x99_M2,100Rnd_127x99_M2};

						stabilizedInAxes 	= 0;
						outGunnerMayFire	= 1;
						inGunnerMayFire		= 0;
						forceHideGunner		= 0;
						viewGunnerInExternal	= 1;
						gunnerForceOptics	= 0;

						gunnerAction		= Abrams_CommanderOut;
						gunnerInAction		= Abrams_Commander;
						gunnerOpticsModel	="\ca\Tracked\optika_M1A1_commander";
						class ViewOptics
						{
							initAngleX=0; minAngleX=-30; maxAngleX=+30;
							initAngleY=0; minAngleY=-100; maxAngleY=+100;
							initFov=0.42; minFov=0.22; maxFov=0.64;
						};
						class ViewGunner
						{
							initAngleX=0; minAngleX=-60; maxAngleX=+60;
							initAngleY=0; minAngleY=-100; maxAngleY=+100;
							initFov=0.42; minFov=0.22; maxFov=0.64;
						};
					};
					class LoaderOptics 		: CommanderOptics
					{
						proxyType		= CPcargo;
						gunnerCompartments	="Compartment3";
						gunnerName		= loader;
						primaryGunner		= 0;
						primaryObserver		= 0;
						commanding		=-1;

						body			="loaderView";
						gun			="loaderView";
						animationSourceBody	="loaderView";
						animationSourceGun	="loaderView";
						animationSourceHatch	="hatchLoader";

						soundServo[]		={"", db-50, 1.0};

						gunBeg			="";
						gunEnd			="";
						weapons[]		={};
						magazines[]		={};
						minElev			=  -5; maxElev	= +5; initElev	=0;
						minTurn			= -60; maxTurn	=+60; initTurn	=0;
						outGunnerMayFire	= 0;
						inGunnerMayFire		= 0;
						forceHideGunner		= 0;
						viewGunnerInExternal	= 1;
						gunnerAction		= Abrams_CommanderOut;
						gunnerInAction		= Abrams_Commander;
						gunnerForceOptics	= 0;
						gunnerOpticsModel	="\ca\Tracked\optika_M1A1_commander";
						memoryPointGunnerOptics ="loaderView";
						startEngine		= 0;
						class ViewOptics
						{
							initAngleX=0; minAngleX=-60; maxAngleX=+60;
							initAngleY=0; minAngleY=-100; maxAngleY=+100;
							initFov=0.42; minFov=0.22; maxFov=0.64;
						};
						class ViewGunner
						{
							initAngleX=5; minAngleX=-30; maxAngleX=+30;
							initAngleY=0; minAngleY=-100; maxAngleY=+100;
							initFov=0.42; minFov=0.22; maxFov=0.64;
						};
					};
				};
			};
		};
		type = 1;
		threat[] = {0.4, 0.4, 0.0};
		
		class Damage {
			tex[] = {};
			mat[] = {};
		};
	};
};
